/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.common.tree.spi;

import java.util.Optional;
import java.util.function.BiFunction;
import org.hibernate.search.engine.common.tree.TreeFilterDefinition;
import org.hibernate.search.engine.common.tree.impl.ConfiguredTreeNestingContext;
import org.hibernate.search.engine.common.tree.impl.ExcludeAllTreeNestingContext;
import org.hibernate.search.engine.common.tree.impl.NotifyingTreeNestingContext;
import org.hibernate.search.engine.common.tree.spi.TreeContributionListener;
import org.hibernate.search.engine.common.tree.spi.TreeFilterPathTracker;
import org.hibernate.search.engine.common.tree.spi.TreeNodeInclusion;
import org.hibernate.search.engine.mapper.model.spi.MappingElement;
import org.hibernate.search.util.common.SearchException;

public interface TreeNestingContext {
    public <T> T nest(String var1, LeafFactory<T> var2);

    public <T> T nest(String var1, CompositeFactory<T> var2);

    public <T> T nestUnfiltered(UnfilteredFactory<T> var1);

    public <T> Optional<T> nestComposed(MappingElement var1, String var2, TreeFilterDefinition var3, TreeFilterPathTracker var4, NestedContextBuilder<T> var5, BiFunction<MappingElement, String, SearchException> var6);

    public static TreeNestingContext root() {
        return ConfiguredTreeNestingContext.ROOT;
    }

    public static TreeNestingContext notifying(TreeNestingContext delegate, TreeContributionListener listener) {
        return new NotifyingTreeNestingContext(delegate, listener);
    }

    public static TreeNestingContext excludeAll() {
        return ExcludeAllTreeNestingContext.INSTANCE;
    }

    public static interface NestedContextBuilder<T> {
        public void appendObject(String var1);

        public T build(TreeNestingContext var1);
    }

    public static interface UnfilteredFactory<T> {
        public T create(TreeNodeInclusion var1, String var2);
    }

    public static interface CompositeFactory<T> {
        public T create(String var1, TreeNodeInclusion var2, TreeNestingContext var3);
    }

    public static interface LeafFactory<T> {
        public T create(String var1, TreeNodeInclusion var2);
    }
}

