/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.user;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.wildfly.clustering.cache.BiCacheEntryCreator;
import org.wildfly.clustering.cache.BiCacheEntryLocator;
import org.wildfly.clustering.cache.CacheEntryRemover;
import org.wildfly.clustering.cache.CacheProperties;
import org.wildfly.clustering.session.cache.user.UserContextFactory;
import org.wildfly.clustering.session.cache.user.UserSessionsFactory;
import org.wildfly.clustering.session.user.User;

public interface UserFactory<CV, C, T, SV, D, S>
extends BiCacheEntryCreator<String, CV, SV, C>,
BiCacheEntryLocator<String, CV, SV>,
CacheEntryRemover<String> {
    public UserContextFactory<CV, C, T> getUserContextFactory();

    public UserSessionsFactory<SV, D, S> getUserSessionsFactory();

    public CacheProperties getCacheProperties();

    public User<C, T, D, S> createUser(String var1, Map.Entry<CV, SV> var2);

    default public Map.Entry<CompletionStage<CV>, CompletionStage<SV>> createEntry(String id, C context) {
        return Map.entry(this.getUserContextFactory().createValueAsync(id, context), this.getUserSessionsFactory().createValueAsync(id, null));
    }

    default public Map.Entry<CompletionStage<CV>, CompletionStage<SV>> findEntry(String id) {
        CompletionStage contextStage = this.getUserContextFactory().findValueAsync(id);
        CompletionStage sessionsStage = this.getCacheProperties().isLockOnRead() ? contextStage.thenCompose(metaData -> metaData != null ? this.getUserSessionsFactory().findValueAsync(id) : CompletableFuture.completedStage(null)) : this.getUserSessionsFactory().findValueAsync(id);
        return Map.entry(contextStage, sessionsStage);
    }

    default public Map.Entry<CompletionStage<CV>, CompletionStage<SV>> tryEntry(String id) {
        CompletionStage contextStage = this.getUserContextFactory().tryValueAsync(id);
        CompletionStage sessionsStage = this.getCacheProperties().isLockOnRead() ? contextStage.thenCompose(metaData -> metaData != null ? this.getUserSessionsFactory().tryValueAsync(id) : CompletableFuture.completedStage(null)) : this.getUserSessionsFactory().tryValueAsync(id);
        return Map.entry(contextStage, sessionsStage);
    }

    default public CompletionStage<Void> removeAsync(String id) {
        return CompletableFuture.allOf(this.getUserContextFactory().removeAsync(id).toCompletableFuture(), this.getUserSessionsFactory().removeAsync(id).toCompletableFuture());
    }

    default public CompletionStage<Void> purgeAsync(String id) {
        return CompletableFuture.allOf(this.getUserContextFactory().purgeAsync(id).toCompletableFuture(), this.getUserSessionsFactory().purgeAsync(id).toCompletableFuture());
    }
}

