/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice.distributable;

import jakarta.transaction.Synchronization;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.ejb3.context.CurrentInvocationContext;
import org.jboss.as.ejb3.timerservice.distributable.TimerSynchronizationFactory;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimer;
import org.jboss.invocation.InterceptorContext;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.batch.SuspendedBatch;
import org.wildfly.clustering.context.Context;
import org.wildfly.clustering.ejb.timer.Timer;

public class DistributableTimerSynchronizationFactory<I>
implements TimerSynchronizationFactory<I> {
    private final Consumer<Timer<I>> activateTask;
    private final Consumer<Timer<I>> cancelTask;

    public DistributableTimerSynchronizationFactory(Consumer<Timer<I>> activateTask, Consumer<Timer<I>> cancelTask) {
        this.activateTask = activateTask;
        this.cancelTask = cancelTask;
    }

    @Override
    public Consumer<Timer<I>> getActivateTask() {
        return this.activateTask;
    }

    @Override
    public Consumer<Timer<I>> getCancelTask() {
        return this.cancelTask;
    }

    @Override
    public Synchronization createActivateSynchronization(Timer<I> timer, Supplier<Batch> batchFactory, SuspendedBatch suspendedBatch) {
        return new DistributableTimerSynchronization<I>(timer, batchFactory, suspendedBatch, this.activateTask, this.cancelTask);
    }

    @Override
    public Synchronization createCancelSynchronization(Timer<I> timer, Supplier<Batch> batchFactory, SuspendedBatch suspendedBatch) {
        return new DistributableTimerSynchronization<I>(timer, batchFactory, suspendedBatch, this.cancelTask, this.activateTask);
    }

    private static class DistributableTimerSynchronization<I>
    implements Synchronization {
        private final Supplier<Batch> batchFactory;
        private final SuspendedBatch suspendedBatch;
        private final Timer<I> timer;
        private final Consumer<Timer<I>> commitTask;
        private final Consumer<Timer<I>> rollbackTask;

        DistributableTimerSynchronization(Timer<I> timer, Supplier<Batch> batchFactory, SuspendedBatch suspendedBatch, Consumer<Timer<I>> commitTask, Consumer<Timer<I>> rollbackTask) {
            this.timer = timer;
            this.batchFactory = batchFactory;
            this.suspendedBatch = suspendedBatch;
            this.commitTask = commitTask;
            this.rollbackTask = rollbackTask;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            InterceptorContext interceptorContext = CurrentInvocationContext.get();
            ManagedTimer currentTimer = interceptorContext != null ? (ManagedTimer)interceptorContext.getTimer() : null;
            try (Context context = this.suspendedBatch.resumeWithContext();){
                Supplier<Object> batchFactory = currentTimer != null && currentTimer.getId().equals(this.timer.getId().toString()) || !((Batch)context.get()).getStatus().isActive() ? this.batchFactory : context;
                try (Batch batch = (Batch)batchFactory.get();){
                    if (!this.timer.isCanceled()) {
                        if (status == 3) {
                            this.commitTask.accept(this.timer);
                        } else {
                            this.rollbackTask.accept(this.timer);
                        }
                    }
                }
            }
        }
    }
}

