/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import org.wildfly.clustering.function.Predicate;

public interface BiPredicate<T, U>
extends java.util.function.BiPredicate<T, U> {
    public static final BiPredicate<?, ?> ALWAYS = (value1, value2) -> true;
    public static final BiPredicate<?, ?> NEVER = (value1, value2) -> false;

    @Override
    default public BiPredicate<T, U> and(final java.util.function.BiPredicate<? super T, ? super U> other) {
        return new BiPredicate<T, U>(){

            @Override
            public boolean test(T value1, U value2) {
                return BiPredicate.this.test(value1, value2) && other.test(value1, value2);
            }
        };
    }

    @Override
    default public BiPredicate<T, U> negate() {
        return new BiPredicate<T, U>(){

            @Override
            public boolean test(T value1, U value2) {
                return !BiPredicate.this.test(value1, value2);
            }
        };
    }

    @Override
    default public BiPredicate<T, U> or(final java.util.function.BiPredicate<? super T, ? super U> other) {
        return new BiPredicate<T, U>(){

            @Override
            public boolean test(T value1, U value2) {
                return BiPredicate.this.test(value1, value2) || other.test(value1, value2);
            }
        };
    }

    default public BiPredicate<T, U> xor(final java.util.function.BiPredicate<? super T, ? super U> other) {
        return new BiPredicate<T, U>(){

            @Override
            public boolean test(T value1, U value2) {
                return BiPredicate.this.test(value1, value2) ^ other.test(value1, value2);
            }
        };
    }

    default public BiPredicate<U, T> reverse() {
        return new BiPredicate<U, T>(){

            @Override
            public boolean test(U value2, T value1) {
                return BiPredicate.this.test(value1, value2);
            }
        };
    }

    public static <T, U> BiPredicate<T, U> always() {
        return ALWAYS;
    }

    public static <T, U> BiPredicate<T, U> never() {
        return NEVER;
    }

    public static <T, U> BiPredicate<T, U> former(java.util.function.Predicate<T> predicate) {
        return BiPredicate.and(predicate, Predicate.always());
    }

    public static <T, U> BiPredicate<T, U> latter(java.util.function.Predicate<U> predicate) {
        return BiPredicate.and(Predicate.always(), predicate);
    }

    public static <T, U> BiPredicate<T, U> and(final java.util.function.Predicate<T> predicate1, final java.util.function.Predicate<U> predicate2) {
        return new BiPredicate<T, U>(){

            @Override
            public boolean test(T value1, U value2) {
                return predicate1.test(value1) && predicate2.test(value2);
            }
        };
    }

    public static <T, U> BiPredicate<T, U> or(final java.util.function.Predicate<T> predicate1, final java.util.function.Predicate<U> predicate2) {
        return new BiPredicate<T, U>(){

            @Override
            public boolean test(T value1, U value2) {
                return predicate1.test(value1) || predicate2.test(value2);
            }
        };
    }

    public static <T, U> BiPredicate<T, U> xor(final java.util.function.Predicate<T> predicate1, final java.util.function.Predicate<U> predicate2) {
        return new BiPredicate<T, U>(){

            @Override
            public boolean test(T value1, U value2) {
                return predicate1.test(value1) ^ predicate2.test(value2);
            }
        };
    }
}

