/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.microprofile.reactive.messaging.common.security;

import javax.net.ssl.SSLContext;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.wildfly.microprofile.reactive.messaging.common._private.MicroProfileReactiveMessagingCommonLogger;

public class ElytronSSLContextRegistry {
    public static final String SSL_CONTEXT_PROPERTY = "wildfly.elytron.ssl.context";
    private static final ElytronSSLContextRegistry INSTANCE = new ElytronSSLContextRegistry();
    private static final ServiceName BASE_CLIENT_SSL_CONTEXT_NAME = ServiceName.of((String[])new String[]{"org", "wildfly", "security", "ssl-context"});
    private volatile ServiceRegistry serviceRegistry;

    private ElytronSSLContextRegistry() {
    }

    public static void setServiceRegistry(ServiceRegistry serviceRegistry) {
        ElytronSSLContextRegistry.INSTANCE.serviceRegistry = serviceRegistry;
    }

    public static boolean isSSLContextInstalled(String name) {
        return INSTANCE.getSSLContextController(name) != null;
    }

    public static SSLContext getInstalledSSLContext(String name) {
        ServiceController<SSLContext> controller = INSTANCE.getSSLContextController(name);
        if (controller == null) {
            throw MicroProfileReactiveMessagingCommonLogger.LOGGER.noElytronClientSSLContext(name);
        }
        return (SSLContext)controller.getValue();
    }

    private ServiceController<SSLContext> getSSLContextController(String name) {
        return this.serviceRegistry.getService(ElytronSSLContextRegistry.getSSLContextName(name));
    }

    public static ServiceName getSSLContextName(String name) {
        return BASE_CLIENT_SSL_CONTEXT_NAME.append(new String[]{name});
    }
}

