/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.service;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Supplier;
import org.jboss.msc.Service;
import org.jboss.msc.service.DelegatingServiceBuilder;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class AsyncServiceBuilder<T>
extends DelegatingServiceBuilder<T> {
    private final Supplier<Executor> executor;
    private final Async async;

    public AsyncServiceBuilder(ServiceBuilder<T> builder, Supplier<Executor> executor) {
        this(builder, executor, Async.START_AND_STOP);
    }

    public AsyncServiceBuilder(ServiceBuilder<T> builder, Supplier<Executor> executor, Async async) {
        super(builder);
        this.executor = executor;
        this.async = async;
    }

    public ServiceBuilder<T> setInstance(Service service) {
        return super.setInstance((Service)new AsyncService(service, this.executor, this.async));
    }

    public static enum Async {
        START_AND_STOP(true, true),
        START_ONLY(true, false),
        STOP_ONLY(false, true);

        private final boolean start;
        private final boolean stop;

        private Async(boolean start, boolean stop) {
            this.start = start;
            this.stop = stop;
        }
    }

    private static class AsyncService
    implements Service {
        private final Service service;
        private final Supplier<Executor> executor;
        private final Async async;

        AsyncService(Service service, Supplier<Executor> executor, Async async) {
            this.service = service;
            this.executor = executor;
            this.async = async;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start(StartContext context) throws StartException {
            if (this.async.start) {
                Runnable task = () -> {
                    try {
                        this.service.start(context);
                        context.complete();
                    }
                    catch (StartException e) {
                        context.failed(e);
                    }
                    catch (Throwable e) {
                        context.failed(new StartException(e));
                    }
                };
                try {
                    this.executor.get().execute(task);
                }
                catch (RejectedExecutionException e) {
                    task.run();
                }
                finally {
                    context.asynchronous();
                }
            } else {
                this.service.start(context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop(StopContext context) {
            if (this.async.stop) {
                Runnable task = () -> {
                    try {
                        this.service.stop(context);
                    }
                    finally {
                        context.complete();
                    }
                };
                try {
                    this.executor.get().execute(task);
                }
                catch (RejectedExecutionException e) {
                    task.run();
                }
                finally {
                    context.asynchronous();
                }
            } else {
                this.service.stop(context);
            }
        }
    }
}

