/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.mgmt;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;

public final class DomainHostExcludeRegistry {
    private final Map<VersionKey, VersionExcludeData> registry = Collections.synchronizedMap(new HashMap());

    VersionExcludeData getVersionIgnoreData(int major, int minor, int micro) {
        VersionExcludeData result = this.registry.get(new VersionKey(major, minor, micro));
        if (result == null) {
            result = this.registry.get(new VersionKey(major, minor, null));
        }
        return result;
    }

    public void recordVersionExcludeData(VersionKey version, Set<String> excludedExtensions, Set<String> activeServerGroups, Set<String> activeSocketBindingGroups) {
        VersionExcludeData value = new VersionExcludeData(excludedExtensions, activeServerGroups, activeSocketBindingGroups);
        this.registry.put(version, value);
        DomainControllerLogger.ROOT_LOGGER.tracef("Recorded %s for %s", value, version);
    }

    public void removeVersionExcludeData(VersionKey version) {
        VersionExcludeData value = this.registry.remove(version);
        DomainControllerLogger.ROOT_LOGGER.tracef("Removed %s for %s", value, version);
    }

    public static final class VersionKey {
        private final int majorVersion;
        private final int minorVersion;
        private final Integer microVersion;

        public VersionKey(int majorVersion, int minorVersion, Integer microVersion) {
            this.majorVersion = majorVersion;
            this.minorVersion = minorVersion;
            this.microVersion = microVersion;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VersionKey that = (VersionKey)o;
            return this.majorVersion == that.majorVersion && this.minorVersion == that.minorVersion && (this.microVersion != null ? this.microVersion.equals(that.microVersion) : that.microVersion == null);
        }

        public int hashCode() {
            int result = this.majorVersion;
            result = 31 * result + this.minorVersion;
            result = 31 * result + (this.microVersion != null ? this.microVersion.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "VersionKey{majorVersion=" + this.majorVersion + ", minorVersion=" + this.minorVersion + ", microVersion=" + this.microVersion + "}";
        }
    }

    static final class VersionExcludeData {
        private final Set<String> excludedExtensions;
        private final Set<String> activeServerGroups;
        private final Set<String> activeSocketBindingGroups;

        private VersionExcludeData(Set<String> excludedExtensions, Set<String> activeServerGroups, Set<String> activeSocketBindingGroups) {
            this.excludedExtensions = excludedExtensions == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<String>(excludedExtensions));
            this.activeServerGroups = activeServerGroups == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<String>(activeServerGroups));
            this.activeSocketBindingGroups = activeSocketBindingGroups == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<String>(activeSocketBindingGroups));
        }

        Set<String> getExcludedExtensions() {
            return this.excludedExtensions;
        }

        Set<String> getActiveServerGroups() {
            return this.activeServerGroups;
        }

        Set<String> getActiveSocketBindingGroups() {
            return this.activeSocketBindingGroups;
        }

        public String toString() {
            return "VersionExcludeData{ignoredExtensions=" + String.valueOf(this.excludedExtensions) + ", activeServerGroups=" + String.valueOf(this.activeServerGroups) + ", activeSocketBindingGroups=" + String.valueOf(this.activeSocketBindingGroups) + "}";
        }
    }
}

