/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Collections;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeParsers;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.MapAttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.xml.XMLCardinality;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public abstract class AttributeParser {
    public static final AttributeParser SIMPLE = new AttributeParser(){};
    public static final AttributeParser STRING_LIST = new AttributeParser(){

        @Override
        public void parseAndSetParameter(AttributeDefinition attribute, String value, ModelNode operation, XMLStreamReader reader) throws XMLStreamException {
            if (value == null) {
                return;
            }
            ModelNode node = operation.get(attribute.getName()).setEmptyList();
            if (!value.isEmpty()) {
                for (String element : value.split("\\s+")) {
                    node.add(this.parse(attribute, element, reader));
                }
            }
        }
    };
    public static final AttributeParser COMMA_DELIMITED_STRING_LIST = new AttributeParser(){

        @Override
        public void parseAndSetParameter(AttributeDefinition attribute, String value, ModelNode operation, XMLStreamReader reader) throws XMLStreamException {
            if (value == null) {
                return;
            }
            ModelNode node = operation.get(attribute.getName()).setEmptyList();
            if (!value.isEmpty()) {
                for (String element : value.split(",")) {
                    node.add(this.parse(attribute, element, reader));
                }
            }
        }
    };
    public static final AttributeParser PROPERTIES_PARSER = new AttributeParsers.PropertiesParser();
    public static final AttributeParser PROPERTIES_PARSER_UNWRAPPED = new AttributeParsers.PropertiesParser(false);
    public static final AttributeParser OBJECT_PARSER = new AttributeParsers.ObjectParser();
    public static final AttributeParser OBJECT_LIST_PARSER = AttributeParsers.WRAPPED_OBJECT_LIST_PARSER;
    public static final AttributeParser WRAPPED_OBJECT_LIST_PARSER = AttributeParsers.WRAPPED_OBJECT_LIST_PARSER;
    public static final AttributeParser UNWRAPPED_OBJECT_LIST_PARSER = AttributeParsers.UNWRAPPED_OBJECT_LIST_PARSER;

    public void parseAndSetParameter(AttributeDefinition attribute, String value, ModelNode operation, XMLStreamReader reader) throws XMLStreamException {
        ModelNode paramVal = this.parse(attribute, value, reader);
        operation.get(attribute.getName()).set(paramVal);
    }

    public ModelNode parse(AttributeDefinition attribute, String value, XMLStreamReader reader) throws XMLStreamException {
        try {
            return this.parse(attribute, value);
        }
        catch (OperationFailedException e) {
            throw new XMLStreamException(e.getFailureDescription().toString(), reader.getLocation());
        }
    }

    private ModelNode parse(AttributeDefinition attribute, String value) throws OperationFailedException {
        ModelNode node = ParseUtils.parseAttributeValue(value, attribute.isAllowExpression(), attribute.getType());
        ParameterValidator validator = attribute instanceof ListAttributeDefinition ? ((ListAttributeDefinition)attribute).getElementValidator() : (attribute instanceof MapAttributeDefinition ? ((MapAttributeDefinition)attribute).getElementValidator() : attribute.getValidator());
        validator.validateParameter(attribute.getXmlName(), node);
        return node;
    }

    public boolean isParseAsElement() {
        return false;
    }

    public void parseElement(AttributeDefinition attribute, XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    public String getXmlName(AttributeDefinition attribute) {
        return attribute.getXmlName();
    }

    public XMLCardinality getCardinality(AttributeDefinition attribute) {
        return this.isParseAsElement() ? (attribute.isNillable() ? XMLCardinality.Single.OPTIONAL : XMLCardinality.Single.REQUIRED) : XMLCardinality.DISABLED;
    }

    public static final class DiscardOldDefaultValueParser
    extends AttributeParser {
        private final String value;

        public DiscardOldDefaultValueParser(String value) {
            this.value = value;
        }

        @Override
        public ModelNode parse(AttributeDefinition attribute, String value, XMLStreamReader reader) throws XMLStreamException {
            if (!this.value.equals(value)) {
                return super.parse(attribute, value, reader);
            }
            return new ModelNode();
        }
    }

    static class WrappedSimpleAttributeParser
    extends AttributeParser {
        WrappedSimpleAttributeParser() {
        }

        @Override
        public boolean isParseAsElement() {
            return true;
        }

        @Override
        public void parseElement(AttributeDefinition attribute, XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
            assert (attribute instanceof SimpleAttributeDefinition);
            if (operation.hasDefined(attribute.getName())) {
                throw ParseUtils.unexpectedElement(reader);
            }
            if (!attribute.getXmlName().equals(reader.getLocalName())) {
                throw ParseUtils.unexpectedElement(reader, Collections.singleton(attribute.getXmlName()));
            }
            ((SimpleAttributeDefinition)attribute).parseAndSetParameter(reader.getElementText(), operation, (XMLStreamReader)reader);
        }
    }
}

