/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.persistence.xml;

import javax.xml.namespace.QName;
import org.jboss.as.controller.FeatureRegistry;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.SubsystemSchema;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.persistence.xml.NamedResourceRegistrationXMLChoice;
import org.jboss.as.controller.persistence.xml.NamedResourceRegistrationXMLElement;
import org.jboss.as.controller.persistence.xml.ResourceXMLAll;
import org.jboss.as.controller.persistence.xml.ResourceXMLChoice;
import org.jboss.as.controller.persistence.xml.ResourceXMLElement;
import org.jboss.as.controller.persistence.xml.ResourceXMLSequence;
import org.jboss.as.controller.persistence.xml.SingletonResourceRegistrationXMLChoice;
import org.jboss.as.controller.persistence.xml.SingletonResourceRegistrationXMLElement;
import org.jboss.as.controller.persistence.xml.SubsystemResourceRegistrationXMLElement;
import org.jboss.as.controller.xml.QNameResolver;
import org.jboss.as.version.Stability;

public interface ResourceXMLParticleFactory
extends FeatureRegistry,
QNameResolver {
    public static <S extends SubsystemSchema<S>> ResourceXMLParticleFactory newInstance(S schema) {
        return ResourceXMLParticleFactory.newInstance(schema, schema);
    }

    public static ResourceXMLParticleFactory newInstance(FeatureRegistry registry, QNameResolver resolver) {
        return new DefaultSubsystemXMLParticleFactory(registry, resolver);
    }

    public SubsystemResourceRegistrationXMLElement.Builder subsystemElement(ResourceRegistration var1);

    public NamedResourceRegistrationXMLElement.Builder namedElement(ResourceRegistration var1);

    public NamedResourceRegistrationXMLChoice.Builder namedElementChoice(NamedResourceRegistrationXMLElement var1);

    public SingletonResourceRegistrationXMLElement.Builder singletonElement(ResourceRegistration var1);

    public SingletonResourceRegistrationXMLChoice.Builder singletonElementChoice();

    default public ResourceXMLElement.Builder element(QName name) {
        return this.element(name, this.getStability());
    }

    public ResourceXMLElement.Builder element(QName var1, Stability var2);

    public ResourceXMLAll.Builder all();

    public ResourceXMLSequence.Builder sequence();

    public ResourceXMLChoice.Builder choice();

    public static class DefaultSubsystemXMLParticleFactory
    implements ResourceXMLParticleFactory {
        private final FeatureRegistry registry;
        private final QNameResolver resolver;

        DefaultSubsystemXMLParticleFactory(FeatureRegistry registry, QNameResolver resolver) {
            this.registry = registry;
            this.resolver = resolver;
        }

        @Override
        public QName resolve(String localName) {
            return this.resolver.resolve(localName);
        }

        @Override
        public Stability getStability() {
            return this.registry.getStability();
        }

        @Override
        public SubsystemResourceRegistrationXMLElement.Builder subsystemElement(ResourceRegistration registration) {
            PathElement path = registration.getPathElement();
            if (path.isWildcard() || !path.getKey().equals("subsystem")) {
                throw ControllerLogger.ROOT_LOGGER.invalidSubsystemPath(path);
            }
            return new SubsystemResourceRegistrationXMLElement.DefaultBuilder(registration, this.registry, this.resolver);
        }

        @Override
        public NamedResourceRegistrationXMLElement.Builder namedElement(ResourceRegistration registration) {
            return new NamedResourceRegistrationXMLElement.DefaultBuilder(registration, this.registry, this.resolver);
        }

        @Override
        public NamedResourceRegistrationXMLChoice.Builder namedElementChoice(NamedResourceRegistrationXMLElement wildcardElement) {
            if (!wildcardElement.getPathElement().isWildcard()) {
                throw ControllerLogger.ROOT_LOGGER.nonWildcardPathNotAllowed(wildcardElement.getPathElement());
            }
            return new NamedResourceRegistrationXMLChoice.DefaultBuilder(wildcardElement, this.registry);
        }

        @Override
        public SingletonResourceRegistrationXMLElement.Builder singletonElement(ResourceRegistration registration) {
            if (registration.getPathElement().isWildcard()) {
                throw ControllerLogger.ROOT_LOGGER.wildcardPathNotAllowed(registration.getPathElement());
            }
            return new SingletonResourceRegistrationXMLElement.DefaultBuilder(registration, this.registry, this.resolver);
        }

        @Override
        public SingletonResourceRegistrationXMLChoice.Builder singletonElementChoice() {
            return new SingletonResourceRegistrationXMLChoice.DefaultBuilder(this.registry);
        }

        @Override
        public ResourceXMLElement.Builder element(QName name, Stability stability) {
            return new ResourceXMLElement.DefaultBuilder(name, stability, this.registry, this.resolver);
        }

        @Override
        public ResourceXMLChoice.Builder choice() {
            return new ResourceXMLChoice.DefaultBuilder(this.registry, this.resolver);
        }

        @Override
        public ResourceXMLAll.Builder all() {
            return new ResourceXMLAll.DefaultBuilder(this.registry, this.resolver);
        }

        @Override
        public ResourceXMLSequence.Builder sequence() {
            return new ResourceXMLSequence.DefaultBuilder(this.registry, this.resolver);
        }
    }
}

