/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.persistence.xml;

import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.FeatureRegistry;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.persistence.xml.AttributeDefinitionXMLConfiguration;
import org.jboss.as.controller.persistence.xml.ResourceRegistrationXMLElement;
import org.jboss.as.controller.persistence.xml.ResourceXMLContainer;
import org.jboss.as.controller.persistence.xml.ResourceXMLElementLocalName;
import org.jboss.as.controller.xml.QNameResolver;
import org.jboss.as.controller.xml.XMLCardinality;
import org.jboss.as.controller.xml.XMLContent;
import org.jboss.as.controller.xml.XMLContentWriter;
import org.jboss.as.controller.xml.XMLElement;
import org.jboss.as.controller.xml.XMLElementReader;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public interface SingletonResourceRegistrationXMLElement
extends ResourceRegistrationXMLElement {

    public static class DefaultSingletonResourceRegistrationXMLElement
    extends ResourceRegistrationXMLElement.DefaultResourceRegistrationXMLElement
    implements SingletonResourceRegistrationXMLElement {
        DefaultSingletonResourceRegistrationXMLElement(ResourceRegistration registration, QName name, XMLCardinality cardinality, XMLElementReader<Map.Entry<PathAddress, Map<PathAddress, ModelNode>>> reader, XMLContentWriter<ModelNode> writer) {
            super(registration, name, cardinality, reader, writer);
        }
    }

    public static class DefaultBuilder
    extends ResourceRegistrationXMLElement.AbstractBuilder<SingletonResourceRegistrationXMLElement, Builder>
    implements Builder {
        private volatile boolean implied = false;

        DefaultBuilder(ResourceRegistration registration, FeatureRegistry registry, QNameResolver resolver) {
            super(registration, registry, resolver);
            this.withElementLocalName(ResourceXMLElementLocalName.VALUE);
        }

        @Override
        public Builder implyIfAbsent() {
            this.implied = true;
            return (Builder)this.withCardinality(XMLCardinality.of(0, this.getCardinality().getMaxOccurs()));
        }

        @Override
        protected Builder builder() {
            return this;
        }

        @Override
        public SingletonResourceRegistrationXMLElement build() {
            final boolean implied = this.implied;
            XMLCardinality cardinality = this.getCardinality();
            ResourceRegistration registration = this.getResourceRegistration();
            final PathElement path = registration.getPathElement();
            final PathElement pathKey = this.getOperationKey().orElse(path);
            QName name = this.getElementName().apply(path);
            Collection<AttributeDefinition> attributes = this.getAttributes();
            AttributeDefinitionXMLConfiguration configuration = this.getConfiguration();
            ResourceXMLContainer.ResourceAttributesXMLContentReader attributesReader = !attributes.isEmpty() ? new ResourceXMLContainer.ResourceAttributesXMLContentReader(attributes, configuration) : ResourceXMLContainer.EMPTY_READER;
            ResourceXMLContainer.ResourceAttributesXMLContentWriter attributesWriter = !attributes.isEmpty() ? new ResourceXMLContainer.ResourceAttributesXMLContentWriter(attributes, configuration) : ResourceXMLContainer.EMPTY_WRITER;
            XMLContent<Map.Entry<PathAddress, Map<PathAddress, ModelNode>>, ModelNode> content = this.getContent();
            final ResourceXMLContainer.ResourceXMLContainerReader resourceReader = new ResourceXMLContainer.ResourceXMLContainerReader(attributesReader, content);
            final XMLElement.DefaultXMLElementWriter<Map.Entry<PathAddress, Map<PathAddress, ModelNode>>, ModelNode, ModelNode> resourceWriter = new XMLElement.DefaultXMLElementWriter<Map.Entry<PathAddress, Map<PathAddress, ModelNode>>, ModelNode, ModelNode>(name, attributesWriter, Function.identity(), content);
            final BiConsumer<Map<PathAddress, ModelNode>, PathAddress> operationTransformation = this.getOperationTransformation();
            XMLElementReader<Map.Entry<PathAddress, Map<PathAddress, ModelNode>>> elementReader = new XMLElementReader<Map.Entry<PathAddress, Map<PathAddress, ModelNode>>>(){

                public void readElement(XMLExtendedStreamReader reader, Map.Entry<PathAddress, Map<PathAddress, ModelNode>> context) throws XMLStreamException {
                    Map.Entry<PathAddress, Map<PathAddress, ModelNode>> entry = this.createOperationEntry(context);
                    resourceReader.readElement(reader, entry);
                    operationTransformation.accept(entry.getValue(), entry.getKey());
                }

                @Override
                public void whenAbsent(Map.Entry<PathAddress, Map<PathAddress, ModelNode>> context) {
                    if (implied) {
                        this.createOperationEntry(context);
                    }
                }

                private Map.Entry<PathAddress, Map<PathAddress, ModelNode>> createOperationEntry(Map.Entry<PathAddress, Map<PathAddress, ModelNode>> context) {
                    PathAddress parentOperationKey = context.getKey();
                    Map<PathAddress, ModelNode> operations = context.getValue();
                    PathAddress operationKey = parentOperationKey.append(pathKey);
                    ModelNode parentOperation = parentOperationKey.size() > 0 ? operations.get(parentOperationKey) : null;
                    PathAddress parentAddress = parentOperation != null ? PathAddress.pathAddress(parentOperation.get("address")) : PathAddress.EMPTY_ADDRESS;
                    PathAddress operationAddress = parentAddress.append(path);
                    ModelNode operation = Util.createAddOperation(operationAddress);
                    operations.put(operationKey, operation);
                    return Map.entry(operationKey, operations);
                }
            };
            XMLContentWriter<ModelNode> elementWriter = new XMLContentWriter<ModelNode>(){

                public void writeContent(XMLExtendedStreamWriter writer, ModelNode parentModel) throws XMLStreamException {
                    String[] pair = path.getKeyValuePair();
                    if (!(!parentModel.has(pair) || implied && this.isEmpty(parentModel))) {
                        resourceWriter.writeContent(writer, parentModel.get(pair));
                    }
                }

                @Override
                public boolean isEmpty(ModelNode parentModel) {
                    String[] pair = path.getKeyValuePair();
                    return !parentModel.hasDefined(pair) || resourceWriter.isEmpty(parentModel.get(pair));
                }
            };
            return new DefaultSingletonResourceRegistrationXMLElement(registration, name, cardinality, elementReader, elementWriter);
        }
    }

    public static interface Builder
    extends ResourceRegistrationXMLElement.Builder<SingletonResourceRegistrationXMLElement, Builder> {
        public Builder implyIfAbsent();
    }
}

