/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.unstable.api.annotation.classpath.runtime.bytecode;

import java.util.Objects;
import java.util.Set;
import org.wildfly.unstable.api.annotation.classpath.index.RuntimeIndex;
import org.wildfly.unstable.api.annotation.classpath.runtime.bytecode.AnnotationUsage;
import org.wildfly.unstable.api.annotation.classpath.runtime.bytecode.AnnotationUsageType;
import org.wildfly.unstable.api.annotation.classpath.runtime.bytecode.AnnotationWithSourceClassUsage;

public class AnnotatedClassUsage
extends AnnotationWithSourceClassUsage {
    private final String referencedClass;

    AnnotatedClassUsage(Set<String> annotations, String className, String referencedClass) {
        super(annotations, AnnotationUsageType.CLASS_USAGE, className);
        this.referencedClass = referencedClass;
    }

    public String getReferencedClass() {
        return this.referencedClass;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AnnotatedClassUsage usage = (AnnotatedClassUsage)o;
        return Objects.equals(this.referencedClass, usage.referencedClass);
    }

    @Override
    protected int calculateHash() {
        return Objects.hash(super.calculateHash(), this.referencedClass);
    }

    @Override
    protected AnnotationUsage convertToDotFormat() {
        return new AnnotatedClassUsage((Set<String>)this.annotations, RuntimeIndex.convertClassNameToDotFormat(this.sourceClass), RuntimeIndex.convertClassNameToDotFormat(this.referencedClass));
    }
}

