/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.session;

import io.undertow.servlet.api.SessionManagerFactory;
import java.util.function.Function;
import java.util.function.Supplier;
import org.wildfly.clustering.web.container.SessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.container.WebDeploymentConfiguration;
import org.wildfly.clustering.web.container.WebDeploymentServiceInstallerProvider;
import org.wildfly.extension.undertow.Server;
import org.wildfly.extension.undertow.deployment.WebDeploymentServiceDescriptor;
import org.wildfly.extension.undertow.logging.UndertowLogger;
import org.wildfly.extension.undertow.session.NonDistributableSessionAffinityProvider;
import org.wildfly.subsystem.service.DeploymentServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class NonDistributableWebDeploymentServiceInstallerProvider
implements WebDeploymentServiceInstallerProvider,
Supplier<WebDeploymentServiceInstallerProvider> {
    private final Function<SessionManagerFactoryConfiguration, SessionManagerFactory> factory;

    public NonDistributableWebDeploymentServiceInstallerProvider(Function<SessionManagerFactoryConfiguration, SessionManagerFactory> factory) {
        this.factory = factory;
    }

    public DeploymentServiceInstaller getSessionManagerFactoryServiceInstaller(SessionManagerFactoryConfiguration configuration) {
        Supplier<SessionManagerFactory> provider = () -> this.factory.apply(configuration);
        return (DeploymentServiceInstaller)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder(provider).provides(WebDeploymentServiceDescriptor.SESSION_MANAGER_FACTORY.resolve(configuration.getDeploymentUnit()))).build();
    }

    public DeploymentServiceInstaller getSessionAffinityProviderServiceInstaller(WebDeploymentConfiguration configuration) {
        ServiceDependency server = ServiceDependency.on(Server.SERVICE_DESCRIPTOR, (String)configuration.getServerName());
        return (DeploymentServiceInstaller)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((ServiceDependency)server.map(NonDistributableSessionAffinityProvider::new)).provides(WebDeploymentServiceDescriptor.SESSION_AFFINITY_PROVIDER.resolve(configuration.getDeploymentUnit()))).build();
    }

    @Override
    public WebDeploymentServiceInstallerProvider get() {
        UndertowLogger.ROOT_LOGGER.clusteringNotSupported();
        return this;
    }
}

