/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.configuration;

import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.counter.api.Storage;
import org.infinispan.counter.configuration.Attribute;
import org.infinispan.counter.configuration.CounterConfigurationBuilder;
import org.infinispan.counter.configuration.CounterManagerConfigurationBuilder;
import org.infinispan.counter.logging.Log;

public abstract class AbstractCounterConfiguration {
    static final AttributeDefinition<Long> INITIAL_VALUE = AttributeDefinition.builder((Enum)Attribute.INITIAL_VALUE, (Object)0L).immutable().build();
    static final AttributeDefinition<Storage> STORAGE = AttributeDefinition.builder((Enum)Attribute.STORAGE, (Object)Storage.VOLATILE).validator(value -> {
        if (value == null) {
            throw Log.CONTAINER.invalidStorageMode();
        }
    }).immutable().build();
    static final AttributeDefinition<String> NAME = AttributeDefinition.builder((Enum)Attribute.NAME, null, String.class).validator(value -> {
        if (value == null) {
            throw Log.CONTAINER.missingCounterName();
        }
    }).autoPersist(false).immutable().build();
    final AttributeSet attributes;

    AbstractCounterConfiguration(AttributeSet attributes) {
        this.attributes = attributes;
    }

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(AbstractCounterConfiguration.class, new AttributeDefinition[]{NAME, INITIAL_VALUE, STORAGE});
    }

    public final AttributeSet attributes() {
        return this.attributes;
    }

    public String name() {
        return (String)this.attributes.attribute(NAME).get();
    }

    public long initialValue() {
        return (Long)this.attributes.attribute(INITIAL_VALUE).get();
    }

    public Storage storage() {
        return (Storage)this.attributes.attribute(STORAGE).get();
    }

    abstract CounterConfigurationBuilder<?, ?> toBuilder(CounterManagerConfigurationBuilder var1);
}

