/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.search.mapper.mapping.impl;

import java.io.InputStream;
import java.net.URL;
import java.util.ServiceLoader;
import org.hibernate.search.engine.environment.classpath.spi.ClassResolver;
import org.hibernate.search.engine.environment.classpath.spi.ResourceResolver;
import org.hibernate.search.engine.environment.classpath.spi.ServiceResolver;
import org.infinispan.search.mapper.log.impl.Log;
import org.infinispan.util.logging.LogFactory;

public final class ClassLoaderServiceImpl
implements ClassResolver,
ResourceResolver,
ServiceResolver {
    private static final Log log = (Log)LogFactory.getLog(ClassLoaderServiceImpl.class, Log.class);
    private final ClassLoader classLoader;

    public ClassLoaderServiceImpl(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Class<?> classForName(String className) {
        try {
            return Class.forName(className, true, this.classLoader);
        }
        catch (Exception | LinkageError e) {
            throw log.unableToLoadTheClass(className, e);
        }
    }

    public InputStream locateResourceStream(String name) {
        try {
            InputStream is = this.classLoader.getResourceAsStream(name);
            if (is != null) {
                return is;
            }
        }
        catch (Exception is) {
            // empty catch block
        }
        if (name.startsWith("/")) {
            String stripped = name.substring(1);
            try {
                return new URL(stripped).openStream();
            }
            catch (Exception exception) {
                try {
                    return this.classLoader.getResourceAsStream(stripped);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public <S> Iterable<S> loadJavaServices(Class<S> serviceContract) {
        return ServiceLoader.load(serviceContract, this.classLoader);
    }
}

