/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd.security.ssl;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Option;
import org.jboss.as.cli.AwaiterModelControllerClient;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.embedded.EmbeddedProcessLaunch;
import org.jboss.as.cli.impl.aesh.cmd.security.SecurityCommand;
import org.jboss.as.cli.impl.aesh.cmd.security.SecurityCommandActivator;
import org.jboss.as.cli.impl.aesh.cmd.security.model.ManagementInterfaces;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.dmr.ModelNode;
import org.wildfly.core.cli.command.DMRCommand;
import org.wildfly.core.cli.command.aesh.CLICommandInvocation;

@CommandDefinition(name="disable-ssl-management", description="", activator=SecurityCommandActivator.class)
public class ManagementDisableSSLCommand
implements Command<CLICommandInvocation>,
DMRCommand {
    @Option(name="no-reload", hasValue=false)
    boolean noReload;
    @Option(name="management-interface", completer=SecurityCommand.OptionCompleters.ManagementInterfaceCompleter.class)
    String managementInterface;
    private final AtomicReference<EmbeddedProcessLaunch> embeddedServerRef;

    public ManagementDisableSSLCommand(AtomicReference<EmbeddedProcessLaunch> embeddedServerRef) {
        this.embeddedServerRef = embeddedServerRef;
    }

    @Override
    public CommandResult execute(CLICommandInvocation commandInvocation) throws CommandException, InterruptedException {
        ModelNode request;
        CommandContext ctx = commandInvocation.getCommandContext();
        try {
            request = this.buildRequest(ctx);
        }
        catch (CommandFormatException ex) {
            throw new CommandException(ex.getLocalizedMessage(), ex);
        }
        this.execute(ctx, request);
        return CommandResult.SUCCESS;
    }

    private void execute(CommandContext ctx, ModelNode request) throws CommandException {
        ModelNode response;
        try {
            response = ctx.getModelControllerClient().execute(request);
        }
        catch (IOException ex) {
            throw new CommandException(ex);
        }
        if (!Util.isSuccess(response)) {
            throw new CommandException(Util.getFailureDescription(response));
        }
        if (!this.noReload) {
            try {
                this.reload(ctx);
                ctx.printLine("Server reloaded.");
                this.reconnect(ctx);
                ctx.printLine("Reconnected to server.");
            }
            catch (CommandLineException ex) {
                throw new CommandException(ex.getLocalizedMessage(), ex);
            }
        } else {
            ctx.printLine("Warning: server has not been reloaded. Call 'reload' to apply changes.");
        }
        ctx.printLine("SSL disabled for " + this.managementInterface);
    }

    private void reload(CommandContext ctx) throws CommandException, OperationFormatException {
        block3: {
            DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
            AwaiterModelControllerClient aclient = (AwaiterModelControllerClient)((Object)ctx.getModelControllerClient());
            try {
                String mode = Util.getRunningMode(ctx);
                builder.setOperationName("reload");
                builder.addProperty("start-mode", "ADMIN_ONLY".equals(mode) ? "ADMIN_ONLY" : "normal");
                ModelNode response = aclient.execute(builder.buildRequest(), true);
                if (!Util.isSuccess(response)) {
                    throw new CommandException(Util.getFailureDescription(response));
                }
            }
            catch (IOException ex) {
                if (!aclient.isConnected()) break block3;
                throw new CommandException(ex);
            }
        }
    }

    private boolean isEmbedded() {
        return this.embeddedServerRef != null && this.embeddedServerRef.get() != null;
    }

    private void reconnect(CommandContext ctx) throws CommandLineException {
        if (this.isEmbedded()) {
            return;
        }
        long start = System.currentTimeMillis();
        long timeoutMillis = (long)ctx.getConfig().getConnectionTimeout() + 1000L;
        while (true) {
            try {
                ctx.connectController();
                break;
            }
            catch (Exception ex) {
                Exception exception = ex;
                if (System.currentTimeMillis() - start > timeoutMillis) {
                    ctx.disconnectController();
                    throw new CommandLineException("Failed to re-establish connection in " + (System.currentTimeMillis() - start) + "ms. " + String.valueOf(exception));
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    ctx.disconnectController();
                    throw new CommandLineException("Interrupted while pausing before reconnecting.", e);
                }
            }
        }
    }

    @Override
    public ModelNode buildRequest(CommandContext context) throws CommandFormatException {
        ModelNode composite = new ModelNode();
        composite.get("operation").set("composite");
        composite.get("address").setEmptyList();
        try {
            this.managementInterface = ManagementInterfaces.disableSSL(context, this.managementInterface, composite.get("steps"));
        }
        catch (Exception ex) {
            throw new CommandFormatException(ex.getLocalizedMessage() == null ? ex.toString() : ex.getLocalizedMessage(), ex);
        }
        return composite;
    }
}

