/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol.mgmt;

import java.io.DataInput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.logging.ProtocolLogger;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.ActiveOperationImpl;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.FlushableDataOutputImpl;
import org.jboss.as.protocol.mgmt.ManagementBatchIdManager;
import org.jboss.as.protocol.mgmt.ManagementMessageHandler;
import org.jboss.as.protocol.mgmt.ManagementProtocolHeader;
import org.jboss.as.protocol.mgmt.ManagementRequest;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.as.protocol.mgmt.ManagementRequestContextImpl;
import org.jboss.as.protocol.mgmt.ManagementRequestHandler;
import org.jboss.as.protocol.mgmt.ManagementRequestHeader;
import org.jboss.as.protocol.mgmt.ManagementResponseHandler;
import org.jboss.as.protocol.mgmt.ManagementResponseHeader;
import org.jboss.as.protocol.mgmt.support.ManagementChannelShutdownHandle;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.MessageOutputStream;
import org.jboss.threads.AsyncFuture;

public abstract class AbstractMessageHandler
implements ManagementMessageHandler,
ManagementChannelShutdownHandle,
CloseHandler<Channel> {
    private static final ActiveOperation.CompletedCallback<?> NO_OP_CALLBACK = new ActiveOperation.CompletedCallback<Object>(){

        @Override
        public void completed(Object result) {
        }

        @Override
        public void failed(Exception e) {
        }

        @Override
        public void cancelled() {
        }
    };
    private final ConcurrentMap<Integer, ActiveOperationImpl<?, ?>> activeRequests = new ConcurrentHashMap(16, 0.75f, Runtime.getRuntime().availableProcessors());
    private final ManagementBatchIdManager operationIdManager = new ManagementBatchIdManager.DefaultManagementBatchIdManager();
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final ExecutorService executorService;
    private final AtomicInteger requestID = new AtomicInteger();
    private final Map<Integer, ActiveRequest<?, ?>> requests = new ConcurrentHashMap(16, 0.75f, Runtime.getRuntime().availableProcessors());
    private int activeCount = 0;
    private volatile boolean shutdown = false;

    static <T> ActiveOperation.CompletedCallback<T> getDefaultCallback() {
        return NO_OP_CALLBACK;
    }

    static <T> ActiveOperation.CompletedCallback<T> getCheckedCallback(ActiveOperation.CompletedCallback<T> callback) {
        if (callback == null) {
            return AbstractMessageHandler.getDefaultCallback();
        }
        return callback;
    }

    protected AbstractMessageHandler(ExecutorService executorService) {
        if (executorService == null) {
            throw ProtocolLogger.ROOT_LOGGER.nullExecutor();
        }
        this.executorService = executorService;
    }

    public void handleChannelClosed(Channel closed, IOException e) {
        for (ActiveOperationImpl activeOperation : this.activeRequests.values()) {
            if (activeOperation.getChannel() != closed) continue;
            activeOperation.getResultHandler().cancel();
        }
    }

    protected boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public void shutdown() {
        this.lock.lock();
        try {
            this.shutdown = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void shutdownNow() {
        this.shutdown();
        this.cancelAllActiveOperations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitCompletion(long timeout, TimeUnit unit) throws InterruptedException {
        long deadline = unit.toMillis(timeout) + System.currentTimeMillis();
        this.lock.lock();
        try {
            boolean allComplete;
            long remaining;
            assert (this.shutdown);
            while (this.activeCount != 0 && (remaining = deadline - System.currentTimeMillis()) > 0L) {
                this.condition.await(remaining, TimeUnit.MILLISECONDS);
            }
            boolean bl = allComplete = this.activeCount == 0;
            if (!allComplete) {
                ProtocolLogger.ROOT_LOGGER.debugf("ActiveOperation(s) %s have not completed within %d %s", (Object)this.activeRequests.keySet(), (Object)timeout, (Object)unit);
            }
            boolean bl2 = allComplete;
            return bl2;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected ExecutorService getExecutor() {
        return this.executorService;
    }

    protected ManagementRequestHandler<?, ?> getRequestHandler(ManagementRequestHeader header) {
        return AbstractMessageHandler.getFallbackHandler(header);
    }

    protected ManagementRequestHeader validateRequest(ManagementProtocolHeader header) {
        return (ManagementRequestHeader)header;
    }

    @Override
    public void handleMessage(Channel channel, DataInput input, ManagementProtocolHeader header) {
        byte type = header.getType();
        if (type == 3) {
            ManagementResponseHeader response = (ManagementResponseHeader)header;
            ActiveRequest<?, ?> request = this.requests.remove(response.getResponseId());
            if (request == null) {
                ProtocolLogger.CONNECTION_LOGGER.noSuchRequest(response.getResponseId(), channel);
                AbstractMessageHandler.safeWriteErrorResponse(channel, header, ProtocolLogger.ROOT_LOGGER.responseHandlerNotFound(response.getResponseId()));
            } else if (response.getError() != null) {
                request.handleFailed(response);
            } else {
                this.handleRequest(channel, input, header, request);
            }
        } else {
            try {
                ManagementRequestHeader requestHeader = this.validateRequest(header);
                ManagementRequestHandler<?, ?> handler = this.getRequestHandler(requestHeader);
                if (handler == null) {
                    AbstractMessageHandler.safeWriteErrorResponse(channel, header, ProtocolLogger.ROOT_LOGGER.responseHandlerNotFound(requestHeader.getBatchId()));
                } else {
                    this.handleMessage(channel, input, requestHeader, handler);
                }
            }
            catch (Exception e) {
                AbstractMessageHandler.safeWriteErrorResponse(channel, header, e);
            }
        }
    }

    protected <T, A> AsyncFuture<T> executeRequest(ManagementRequest<T, A> request, Channel channel, ActiveOperation<T, A> support) {
        assert (support != null);
        AbstractMessageHandler.updateChannelRef(support, channel);
        Integer requestId = this.requestID.incrementAndGet();
        ActiveRequest<T, A> ar = new ActiveRequest<T, A>(support, request);
        this.requests.put(requestId, ar);
        ManagementRequestHeader header = new ManagementRequestHeader(2, requestId, support.getOperationId(), request.getOperationType());
        ActiveOperation.ResultHandler<T> resultHandler = support.getResultHandler();
        try {
            request.sendRequest(resultHandler, new ManagementRequestContextImpl<T, A>(support, channel, header, this.getExecutor()));
        }
        catch (Exception e) {
            resultHandler.failed(e);
            this.requests.remove(requestId);
        }
        return support.getResult();
    }

    <T, A> void handleRequest(Channel channel, DataInput message, ManagementProtocolHeader header, ActiveRequest<T, A> activeRequest) {
        this.handleMessage(channel, message, header, activeRequest.context, activeRequest.handler);
    }

    protected <T, A> void handleMessage(Channel channel, DataInput message, ManagementRequestHeader header, ManagementRequestHandler<T, A> handler) throws IOException {
        ActiveOperation<T, A> support = this.getActiveOperation(header);
        if (support == null) {
            throw ProtocolLogger.ROOT_LOGGER.responseHandlerNotFound(header.getBatchId());
        }
        this.handleMessage(channel, message, header, support, handler);
    }

    protected <T, A> void handleMessage(Channel channel, DataInput message, ManagementProtocolHeader header, ActiveOperation<T, A> support, ManagementRequestHandler<T, A> handler) {
        assert (support != null);
        AbstractMessageHandler.updateChannelRef(support, channel);
        ActiveOperation.ResultHandler<T> resultHandler = support.getResultHandler();
        try {
            handler.handleRequest(message, resultHandler, new ManagementRequestContextImpl<T, A>(support, channel, header, this.getExecutor()));
        }
        catch (Exception e) {
            resultHandler.failed(e);
            AbstractMessageHandler.safeWriteErrorResponse(channel, header, e);
        }
    }

    @Override
    public void handleClose(Channel closed, IOException exception) {
        this.handleChannelClosed(closed, exception);
    }

    protected <T, A> ActiveOperation<T, A> registerActiveOperation(A attachment) {
        ActiveOperation.CompletedCallback<T> callback = AbstractMessageHandler.getDefaultCallback();
        return this.registerActiveOperation(attachment, callback);
    }

    protected <T, A> ActiveOperation<T, A> registerActiveOperation(A attachment, ActiveOperation.CompletedCallback<T> callback) {
        return this.registerActiveOperation(null, attachment, callback);
    }

    protected <T, A> ActiveOperation<T, A> registerActiveOperation(Integer id, A attachment) {
        ActiveOperation.CompletedCallback<T> callback = AbstractMessageHandler.getDefaultCallback();
        return this.registerActiveOperation(id, attachment, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T, A> ActiveOperation<T, A> registerActiveOperation(Integer id, A attachment, ActiveOperation.CompletedCallback<T> callback) {
        this.lock.lock();
        try {
            Integer operationId;
            if (id == null) {
                operationId = this.operationIdManager.createBatchId();
            } else {
                if (!this.operationIdManager.lockBatchId(id)) {
                    throw ProtocolLogger.ROOT_LOGGER.operationIdAlreadyExists(id);
                }
                operationId = id;
            }
            ActiveOperationImpl<T, A> request = new ActiveOperationImpl<T, A>(operationId, attachment, AbstractMessageHandler.getCheckedCallback(callback), this);
            ActiveOperation existing = this.activeRequests.putIfAbsent(operationId, request);
            if (existing != null) {
                throw ProtocolLogger.ROOT_LOGGER.operationIdAlreadyExists(operationId);
            }
            ProtocolLogger.ROOT_LOGGER.tracef("Registered active operation %d", (Object)operationId);
            ++this.activeCount;
            ActiveOperationImpl<T, A> activeOperationImpl = request;
            return activeOperationImpl;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected <T, A> ActiveOperation<T, A> getActiveOperation(ManagementRequestHeader header) {
        return this.getActiveOperation(header.getBatchId());
    }

    protected <T, A> ActiveOperation<T, A> getActiveOperation(Integer id) {
        return (ActiveOperation)this.activeRequests.get(id);
    }

    protected List<Integer> cancelAllActiveOperations() {
        ArrayList<Integer> operations = new ArrayList<Integer>();
        for (ActiveOperationImpl activeOperation : this.activeRequests.values()) {
            activeOperation.asyncCancel(false);
            operations.add(activeOperation.getOperationId());
        }
        return operations;
    }

    protected <T, A> ActiveOperation<T, A> removeActiveOperation(Integer id) {
        ActiveOperation<T, A> removed = this.removeUnderLock(id);
        if (removed != null) {
            for (Map.Entry<Integer, ActiveRequest<?, ?>> requestEntry : this.requests.entrySet()) {
                ActiveRequest<?, ?> request = requestEntry.getValue();
                if (request.context != removed) continue;
                this.requests.remove(requestEntry.getKey());
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, A> ActiveOperation<T, A> removeUnderLock(Integer id) {
        this.lock.lock();
        try {
            ActiveOperation removed = (ActiveOperation)this.activeRequests.remove(id);
            if (removed != null) {
                ProtocolLogger.ROOT_LOGGER.tracef("Deregistered active operation %d", (Object)id);
                --this.activeCount;
                this.operationIdManager.freeBatchId(id);
                this.condition.signalAll();
            }
            ActiveOperation activeOperation = removed;
            return activeOperation;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected static void safeWriteErrorResponse(Channel channel, ManagementProtocolHeader header, Throwable error) {
        if (header.getType() == 2) {
            try {
                AbstractMessageHandler.writeErrorResponse(channel, (ManagementRequestHeader)header, error);
            }
            catch (IOException ioe) {
                ProtocolLogger.ROOT_LOGGER.tracef((Throwable)ioe, "failed to write error response for %s on channel: %s", (Object)header, (Object)channel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeErrorResponse(Channel channel, ManagementRequestHeader header, Throwable error) throws IOException {
        ManagementResponseHeader response = ManagementResponseHeader.create(header, error);
        MessageOutputStream output = channel.writeMessage();
        try {
            AbstractMessageHandler.writeHeader(response, output);
            output.close();
        }
        finally {
            StreamUtils.safeClose(output);
        }
    }

    protected static FlushableDataOutput writeHeader(ManagementProtocolHeader header, OutputStream os) throws IOException {
        FlushableDataOutput output = FlushableDataOutputImpl.create(os);
        header.write(output);
        return output;
    }

    protected static <T, A> ManagementRequestHandler<T, A> getFallbackHandler(final ManagementRequestHeader header) {
        return new ManagementRequestHandler<T, A>(){

            @Override
            public void handleRequest(DataInput input, ActiveOperation.ResultHandler<T> resultHandler, ManagementRequestContext<A> context) {
                IOException error = ProtocolLogger.ROOT_LOGGER.noSuchResponseHandler(Integer.toHexString(header.getRequestId()));
                if (resultHandler.failed(error)) {
                    AbstractMessageHandler.safeWriteErrorResponse(context.getChannel(), context.getRequestHeader(), error);
                }
            }
        };
    }

    private static void updateChannelRef(ActiveOperation<?, ?> operation, Channel channel) {
        if (operation instanceof ActiveOperationImpl) {
            ActiveOperationImpl a = (ActiveOperationImpl)operation;
            a.updateChannelRef(channel);
        }
    }

    private static class ActiveRequest<T, A> {
        private final ActiveOperation<T, A> context;
        private final ManagementResponseHandler<T, A> handler;

        ActiveRequest(ActiveOperation<T, A> context, ManagementResponseHandler<T, A> handler) {
            this.context = context;
            this.handler = handler;
        }

        protected void handleFailed(ManagementResponseHeader header) {
            this.handler.handleFailed(header, this.context.getResultHandler());
        }
    }
}

