/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.syntax.parser;

import java.util.List;
import java.util.Objects;
import org.infinispan.objectfilter.impl.logging.Log;
import org.infinispan.objectfilter.impl.ql.Function;
import org.infinispan.objectfilter.impl.ql.PropertyPath;
import org.infinispan.objectfilter.impl.syntax.parser.TypeDescriptor;
import org.jboss.logging.Logger;

public final class FunctionPropertyPath<TypeMetadata>
extends PropertyPath<TypeDescriptor<TypeMetadata>> {
    private static final Log log = (Log)Logger.getMessageLogger(Log.class, (String)FunctionPropertyPath.class.getName());
    private final Function function;
    private final List<Object> args;

    public FunctionPropertyPath(PropertyPath<TypeDescriptor<TypeMetadata>> path, Function function, List<Object> args) {
        this(path.getNodes(), function, args);
    }

    public FunctionPropertyPath(List<PropertyPath.PropertyReference<TypeDescriptor<TypeMetadata>>> path, Function function, List<Object> args) {
        super(path);
        switch (function) {
            case DISTANCE: {
                break;
            }
            default: {
                throw log.functionNotSupportedException(function.name());
            }
        }
        this.function = function;
        this.args = args;
    }

    public Function getFunction() {
        return this.function;
    }

    public List<Object> getArgs() {
        return this.args;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FunctionPropertyPath that = (FunctionPropertyPath)o;
        return this.function == that.function && Objects.equals(this.args, that.args);
    }

    @Override
    public int hashCode() {
        int hash = 31 * super.hashCode() + this.function.hashCode();
        if (this.args != null) {
            for (Object arg : this.args) {
                hash = 31 * hash + (arg != null ? arg.hashCode() : 0);
            }
        }
        return hash;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(this.function.toString());
        builder.append("(");
        builder.append(this.asStringPath());
        for (Object arg : this.args) {
            builder.append(", ");
            builder.append(arg);
        }
        builder.append(")");
        return builder.toString();
    }
}

