/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client.helpers;

import java.util.function.BiFunction;

public final class JBossModulesNameUtil {
    public static String parseCanonicalModuleIdentifier(String moduleSpec) {
        return JBossModulesNameUtil.parseModuleIdentifier(moduleSpec, JBossModulesNameUtil::canonicalModuleIdentifier);
    }

    public static <R> R parseModuleIdentifier(String moduleIdentifier, BiFunction<String, String, R> function) {
        return JBossModulesNameUtil.parseModuleIdentifier(moduleIdentifier, function, false, null);
    }

    public static <R> R parseModuleIdentifier(String moduleIdentifier, BiFunction<String, String, R> function, boolean canonicalize) {
        return JBossModulesNameUtil.parseModuleIdentifier(moduleIdentifier, function, canonicalize, null);
    }

    public static <R> R parseModuleIdentifier(String moduleIdentifier, BiFunction<String, String, R> function, boolean canonicalize, String defaultSlot) {
        int c;
        if (canonicalize) {
            moduleIdentifier = JBossModulesNameUtil.parseCanonicalModuleIdentifier(moduleIdentifier);
        }
        if (moduleIdentifier == null) {
            throw new IllegalArgumentException("Module specification is null");
        }
        if (moduleIdentifier.isEmpty()) {
            throw new IllegalArgumentException("Empty module specification");
        }
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < moduleIdentifier.length()) {
            c = moduleIdentifier.codePointAt(i);
            if (c == 92) {
                b.appendCodePoint(c);
                i = moduleIdentifier.offsetByCodePoints(i, 1);
                if (i >= moduleIdentifier.length()) {
                    throw new IllegalArgumentException("Name has an unterminated escape");
                }
                c = moduleIdentifier.codePointAt(i);
                b.appendCodePoint(c);
            } else {
                if (c == 58) {
                    if ((i = moduleIdentifier.offsetByCodePoints(i, 1)) != moduleIdentifier.length()) break;
                    throw new IllegalArgumentException("Slot is empty");
                }
                b.appendCodePoint(c);
            }
            i = moduleIdentifier.offsetByCodePoints(i, 1);
        }
        String name = b.toString();
        b.setLength(0);
        if (i >= moduleIdentifier.length()) {
            return function.apply(name, defaultSlot);
        }
        do {
            c = moduleIdentifier.codePointAt(i);
            b.appendCodePoint(c);
        } while ((i = moduleIdentifier.offsetByCodePoints(i, 1)) < moduleIdentifier.length());
        return function.apply(name, b.toString());
    }

    public static String canonicalModuleIdentifier(String name, String slot) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        String escaped = JBossModulesNameUtil.escapeName(name);
        return slot == null || "main".equals(slot) ? escaped : escaped + ":" + JBossModulesNameUtil.escapeSlot(slot);
    }

    private static String escapeName(String name) {
        StringBuilder b = new StringBuilder();
        boolean escaped = false;
        int i = 0;
        while (i < name.length()) {
            int c = name.codePointAt(i);
            switch (c) {
                case 58: 
                case 92: {
                    escaped = true;
                    b.append('\\');
                }
            }
            b.appendCodePoint(c);
            i = name.offsetByCodePoints(i, 1);
        }
        return escaped ? b.toString() : name;
    }

    private static String escapeSlot(String slot) {
        StringBuilder b = new StringBuilder();
        boolean escaped = false;
        int i = 0;
        while (i < slot.length()) {
            int c = slot.codePointAt(i);
            switch (c) {
                case 92: {
                    escaped = true;
                    b.append('\\');
                }
            }
            b.appendCodePoint(c);
            i = slot.offsetByCodePoints(i, 1);
        }
        return escaped ? b.toString() : slot;
    }
}

