/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.context;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ThreadFactory;
import org.wildfly.clustering.context.ContextReference;
import org.wildfly.clustering.context.Contextualizer;

public class ContextualThreadFactory<C>
implements ThreadFactory {
    private final ThreadFactory factory;
    private final Contextualizer contextualizer;

    public ContextualThreadFactory(ThreadFactory factory, C targetContext, ContextReference<C> contextReference) {
        this(factory, Contextualizer.withContextProvider(contextReference.provide(targetContext)));
    }

    ContextualThreadFactory(ThreadFactory factory, Contextualizer contextualizer) {
        this.factory = factory;
        this.contextualizer = contextualizer;
    }

    @Override
    public Thread newThread(final Runnable task) {
        Thread thread = AccessController.doPrivileged(new PrivilegedAction<Thread>(){

            @Override
            public Thread run() {
                return ContextualThreadFactory.this.factory.newThread(ContextualThreadFactory.this.contextualizer.contextualize(task));
            }
        });
        return thread;
    }
}

