/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd.security.ssl;

import java.io.File;
import java.io.IOException;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.option.Option;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.impl.aesh.cmd.RelativeFile;
import org.jboss.as.cli.impl.aesh.cmd.RelativeFilePathConverter;
import org.jboss.as.cli.impl.aesh.cmd.security.SecurityCommand;
import org.jboss.as.cli.impl.aesh.cmd.security.model.ElytronUtil;
import org.jboss.as.cli.impl.aesh.cmd.security.model.InteractiveSecurityBuilder;
import org.jboss.as.cli.impl.aesh.cmd.security.model.KeyStoreNameSecurityBuilder;
import org.jboss.as.cli.impl.aesh.cmd.security.model.KeyStorePathSecurityBuilder;
import org.jboss.as.cli.impl.aesh.cmd.security.model.SSLSecurityBuilder;
import org.jboss.as.cli.impl.aesh.cmd.security.ssl.OptionActivators;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.dmr.ModelNode;
import org.wildfly.core.cli.command.DMRCommand;
import org.wildfly.core.cli.command.aesh.CLICommandInvocation;

@CommandDefinition(name="abstract-ssl-enable", description="")
public abstract class AbstractEnableSSLCommand
implements Command<CLICommandInvocation>,
DMRCommand {
    @Option(name="key-store-name", completer=SecurityCommand.OptionCompleters.KeyStoreNameCompleter.class, activator=OptionActivators.KeyStoreNameActivator.class)
    String keystoreName;
    @Option(name="key-store-path", activator=OptionActivators.KeyStorePathActivator.class, converter=RelativeFilePathConverter.class, completer=FileOptionCompleter.class)
    RelativeFile keystorePath;
    @Option(name="key-store-path-relative-to", activator=OptionActivators.KeyStorePathDependentActivator.class)
    String keystorePathRelativeTo;
    @Option(name="key-store-password", activator=OptionActivators.KeyStorePathDependentActivator.class)
    String keystorePassword;
    @Option(name="trusted-certificate-path", activator=OptionActivators.TrustedCertificateActivator.class)
    File trustedCertificatePath;
    @Option(name="no-trusted-certificate-validation", activator=OptionActivators.ValidateTrustedCertificateActivator.class, hasValue=false)
    boolean noTrustedCertificateValidation;
    @Option(name="trust-store-name", completer=SecurityCommand.OptionCompleters.KeyStoreNameCompleter.class, activator=OptionActivators.TrustStoreNameActivator.class)
    String trustStoreName;
    @Option(name="trust-store-file-name", activator=OptionActivators.TrustStoreFileNameActivator.class)
    String trustStoreFileName;
    @Option(name="new-trust-store-name", activator=OptionActivators.NewTrustStoreNameActivator.class)
    String newTrustStoreName;
    @Option(name="new-trust-manager-name", activator=OptionActivators.NewTrustManagerNameActivator.class)
    String newTrustManagerName;
    @Option(name="trust-store-file-password", activator=OptionActivators.TrustStoreFilePasswordActivator.class)
    String trustStoreFilePassword;
    @Option(name="key-store-type", activator=OptionActivators.KeyStorePathDependentActivator.class, completer=SecurityCommand.OptionCompleters.KeyStoreTypeCompleter.class)
    String keyStoreType;
    @Option(name="new-key-manager-name", activator=OptionActivators.NewKeyManagerNameActivator.class)
    String newKeyManagerName;
    @Option(name="new-ssl-context-name", activator=OptionActivators.NewSSLContextNameActivator.class)
    String newSslContextName;
    @Option(name="new-key-store-name", activator=OptionActivators.NewKeyStoreNameActivator.class)
    String newKeystoreName;
    @Option(name="no-reload", hasValue=false, activator=OptionActivators.NoReloadActivator.class)
    boolean noReload;
    @Option(name="interactive", hasValue=false, activator=OptionActivators.InteractiveActivator.class)
    boolean interactive;
    @Option(name="lets-encrypt", hasValue=false, activator=OptionActivators.LetsEncryptActivator.class)
    boolean useLetsEncrypt;
    @Option(name="ca-account", completer=SecurityCommand.OptionCompleters.CaAccountNameCompleter.class, activator=OptionActivators.CaAccountActivator.class)
    String caAccount;
    private final CommandContext initCtx;

    protected abstract void secure(CommandContext var1, SSLSecurityBuilder var2) throws CommandException;

    protected AbstractEnableSSLCommand(CommandContext initCtx) {
        this.initCtx = initCtx;
    }

    CommandContext getCommandContext() {
        return this.initCtx;
    }

    @Override
    public ModelNode buildRequest(CommandContext context) throws CommandFormatException {
        try {
            return this.buildSecurityRequest(context, null).buildExecutableRequest(context);
        }
        catch (Exception ex) {
            throw new CommandFormatException(ex.getLocalizedMessage() == null ? ex.toString() : ex.getLocalizedMessage());
        }
    }

    private SSLSecurityBuilder buildSecurityRequest(CommandContext context, CLICommandInvocation commandInvocation) throws Exception {
        SSLSecurityBuilder builder = this.validateOptions(context);
        if (builder instanceof InteractiveSecurityBuilder) {
            ((InteractiveSecurityBuilder)builder).setCommandInvocation(commandInvocation);
        }
        builder.buildRequest(context, commandInvocation == null);
        this.secure(context, builder);
        return builder;
    }

    protected abstract boolean isSSLEnabled(CommandContext var1) throws Exception;

    protected abstract String getTarget(CommandContext var1);

    public CommandResult execute(CLICommandInvocation commandInvocation) throws CommandException, InterruptedException {
        SSLSecurityBuilder builder;
        CommandContext ctx = commandInvocation.getCommandContext();
        String target = this.getTarget(ctx);
        try {
            if (this.isSSLEnabled(ctx)) {
                throw new CommandException("SSL is already enabled for " + target);
            }
        }
        catch (Exception ex) {
            throw new CommandException(ex.getLocalizedMessage(), (Throwable)ex);
        }
        try {
            builder = this.buildSecurityRequest(ctx, commandInvocation);
        }
        catch (Exception ex) {
            throw new CommandException(ex.getLocalizedMessage());
        }
        try {
            SecurityCommand.execute(ctx, builder.buildExecutableRequest(ctx), builder, this.noReload);
        }
        catch (Exception ex) {
            if (ex instanceof CommandException) {
                throw (CommandException)((Object)ex);
            }
            throw new CommandException(ex.getLocalizedMessage());
        }
        commandInvocation.getCommandContext().printLine("SSL enabled for " + target);
        commandInvocation.getCommandContext().printLine("ssl-context is " + builder.getServerSSLContext().getName());
        commandInvocation.getCommandContext().printLine("key-manager is " + builder.getServerSSLContext().getKeyManager().getName());
        commandInvocation.getCommandContext().printLine("key-store   is " + builder.getServerSSLContext().getKeyManager().getKeyStore().getName());
        return CommandResult.SUCCESS;
    }

    abstract String getDefaultKeyStoreFileName(CommandContext var1);

    abstract String getDefaultTrustStoreFileName(CommandContext var1);

    private SSLSecurityBuilder validateOptions(CommandContext ctx) throws CommandException, IOException, OperationFormatException {
        if (this.keystoreName == null && this.keystorePath == null && !this.interactive) {
            throw new CommandException("One of " + SecurityCommand.formatOption("interactive") + ", " + SecurityCommand.formatOption("key-store-name") + ", " + SecurityCommand.formatOption("key-store-path") + " must be set");
        }
        SSLSecurityBuilder builder = null;
        if (this.keystorePath != null) {
            File path;
            if (this.keystoreName != null) {
                throw new CommandException(SecurityCommand.formatOption("key-store-name") + " can't be used with " + SecurityCommand.formatOption("key-store-path"));
            }
            if (this.keystorePathRelativeTo != null) {
                path = new File(this.keystorePath.getOriginalPath());
            } else {
                path = this.keystorePath;
                if (!path.exists()) {
                    throw new CommandException("File " + String.valueOf(path) + " doesn't exist.");
                }
            }
            KeyStorePathSecurityBuilder kspBuilder = new KeyStorePathSecurityBuilder(path, this.keystorePassword);
            kspBuilder.setRelativeTo(this.keystorePathRelativeTo).setType(this.keyStoreType).setName(this.newKeystoreName);
            builder = kspBuilder;
        }
        if (this.keystoreName != null) {
            if (builder != null) {
                AbstractEnableSSLCommand.invalidUseCase();
            }
            if (this.newKeystoreName != null || this.keystorePassword != null || this.keyStoreType != null || this.keystorePathRelativeTo != null || this.keystorePath != null) {
                throw new CommandException("key-store file related options can't be used with " + SecurityCommand.formatOption("key-store-name"));
            }
            if (!ElytronUtil.keyStoreExists(ctx, this.keystoreName)) {
                throw new CommandException("key-store " + this.keystoreName + " doesn't exist");
            }
            builder = new KeyStoreNameSecurityBuilder(this.keystoreName);
        }
        if (this.interactive) {
            if (builder != null) {
                AbstractEnableSSLCommand.invalidUseCase();
            }
            AbstractEnableSSLCommand.checkKeyStoreOperationsSupported(ctx, "interactive");
            builder = new InteractiveSecurityBuilder(this.getDefaultKeyStoreFileName(ctx), this.getDefaultTrustStoreFileName(ctx), this.useLetsEncrypt, this.caAccount);
        }
        if (this.trustedCertificatePath != null) {
            AbstractEnableSSLCommand.checkKeyStoreOperationsSupported(ctx, "trusted-certificate-path");
            if (!this.trustedCertificatePath.exists()) {
                throw new CommandException("The client certificate path " + String.valueOf(this.trustedCertificatePath) + " doesn't exist");
            }
            if (this.trustStoreName != null) {
                throw new CommandException(SecurityCommand.formatOption("trust-store-name") + " can't be used when " + SecurityCommand.formatOption("trusted-certificate-path") + " is in use");
            }
        }
        if (this.trustStoreName != null && !ElytronUtil.keyStoreExists(ctx, this.trustStoreName)) {
            throw new CommandException("key-store " + this.trustStoreName + " doesn't exist");
        }
        if (builder != null) {
            builder.setTrustedCertificatePath(this.trustedCertificatePath);
            builder.setValidateCertificate(!this.noTrustedCertificateValidation);
            builder.setTrustStoreFileName(this.trustStoreFileName);
            builder.setTrustStoreFilePassword(this.trustStoreFilePassword);
            builder.setTrustStoreName(this.trustStoreName);
            builder.setNewTrustStoreName(this.newTrustStoreName);
            builder.setNewTrustManagerName(this.newTrustManagerName);
            builder.setKeyManagerName(this.newKeyManagerName);
            builder.setSSLContextName(this.newSslContextName);
        }
        return builder;
    }

    private static void checkKeyStoreOperationsSupported(CommandContext ctx, String option) throws IOException, OperationFormatException, CommandException {
        if (!ElytronUtil.isKeyStoreManagementSupported(ctx)) {
            throw new CommandException("Operations to manage key-store are not available, the option " + SecurityCommand.formatOption(option) + " can't be used");
        }
    }

    private static void invalidUseCase() throws CommandException {
        throw new CommandException("Only one of " + SecurityCommand.formatOption("interactive") + ", " + SecurityCommand.formatOption("key-store-name") + ", " + SecurityCommand.formatOption("key-store-path") + "must  be set");
    }
}

