/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.broker;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPLargeMessagePersister;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessagePersister;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessagePersisterV2;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessagePersisterV3;
import org.apache.activemq.artemis.protocol.amqp.broker.AmqpInterceptor;
import org.apache.activemq.artemis.protocol.amqp.broker.ProtonProtocolManager;
import org.apache.activemq.artemis.protocol.amqp.connect.AMQPBrokerConnectionManager;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AckManager;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AckManagerProvider;
import org.apache.activemq.artemis.spi.core.protocol.AbstractProtocolManagerFactory;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManager;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManagerFactory;
import org.apache.activemq.artemis.utils.uri.BeanSupport;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ProtocolManagerFactory.class})
public class ProtonProtocolManagerFactory
extends AbstractProtocolManagerFactory<AmqpInterceptor> {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String AMQP_PROTOCOL_NAME = "AMQP";
    private static final String MODULE_NAME = "artemis-amqp-protocol";
    private static String[] SUPPORTED_PROTOCOLS = new String[]{"AMQP"};
    private AMQPBrokerConnectionManager brokerConnectionManager;

    public Persister<Message>[] getPersister() {
        Persister[] persisters = new Persister[]{AMQPMessagePersister.getInstance(), AMQPMessagePersisterV2.getInstance(), AMQPLargeMessagePersister.getInstance(), AMQPMessagePersisterV3.getInstance()};
        return persisters;
    }

    public ProtocolManager createProtocolManager(ActiveMQServer server, Map<String, Object> parameters, List<BaseInterceptor> incomingInterceptors, List<BaseInterceptor> outgoingInterceptors) throws Exception {
        BeanSupport.stripPasswords(parameters);
        return (ProtocolManager)BeanSupport.setData((Object)((Object)new ProtonProtocolManager(this, server, incomingInterceptors, outgoingInterceptors)), parameters);
    }

    public List<AmqpInterceptor> filterInterceptors(List<BaseInterceptor> interceptors) {
        return this.internalFilterInterceptors(AmqpInterceptor.class, interceptors);
    }

    public String[] getProtocols() {
        return SUPPORTED_PROTOCOLS;
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public void loadProtocolServices(ActiveMQServer server, List<ActiveMQComponent> services) {
        try {
            AckManager ackManager = AckManagerProvider.getManager(server);
            services.add(ackManager);
            server.registerRecordsLoader(ackManager::reload);
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        List amqpServicesConfigurations = server.getConfiguration().getAMQPConnection();
        if (amqpServicesConfigurations != null && !amqpServicesConfigurations.isEmpty()) {
            this.brokerConnectionManager = new AMQPBrokerConnectionManager(this, amqpServicesConfigurations, server);
            services.add(this.brokerConnectionManager);
        }
    }

    public void updateProtocolServices(ActiveMQServer server, List<ActiveMQComponent> services) throws Exception {
        if (this.brokerConnectionManager == null) {
            this.checkAddNewBrokerConnectionManager(server, services);
        } else {
            this.updateBrokerConnectionManager(server, services);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBrokerConnectionManager(ActiveMQServer server, List<ActiveMQComponent> services) throws Exception {
        List amqpServicesConfigurations = server.getConfiguration().getAMQPConnection();
        this.brokerConnectionManager.updateConfiguration(amqpServicesConfigurations);
        if (this.brokerConnectionManager.getConfiguredConnectionsCount() == 0) {
            try {
                this.brokerConnectionManager.stop();
            }
            finally {
                services.remove(this.brokerConnectionManager);
                this.brokerConnectionManager = null;
            }
        }
    }

    private void checkAddNewBrokerConnectionManager(ActiveMQServer server, List<ActiveMQComponent> services) throws Exception {
        List amqpServicesConfigurations = server.getConfiguration().getAMQPConnection();
        if (amqpServicesConfigurations != null && !amqpServicesConfigurations.isEmpty()) {
            this.brokerConnectionManager = new AMQPBrokerConnectionManager(this, amqpServicesConfigurations, server);
            services.add(this.brokerConnectionManager);
            this.brokerConnectionManager.start();
        }
    }
}

