/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.deployment;

import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.server.deployment.SetupAction;
import org.jboss.as.txn.logging.TransactionLogger;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public final class TransactionRollbackSetupAction
implements SetupAction,
Service {
    private static final ThreadLocal<Holder> depth = new ThreadLocal();
    private final Consumer<TransactionRollbackSetupAction> txnRollbackSetupActionConsumer;
    private final Supplier<TransactionManager> transactionManagerSupplier;
    private final ServiceName serviceName;

    public TransactionRollbackSetupAction(Consumer<TransactionRollbackSetupAction> txnRollbackSetupActionConsumer, Supplier<TransactionManager> transactionManagerSupplier, ServiceName serviceName) {
        this.txnRollbackSetupActionConsumer = txnRollbackSetupActionConsumer;
        this.transactionManagerSupplier = transactionManagerSupplier;
        this.serviceName = serviceName;
    }

    public void setup(Map<String, Object> properties) {
        this.changeDepth(1);
    }

    public void teardown(Map<String, Object> properties) {
        if (this.changeDepth(-1)) {
            this.checkTransactionStatus();
        }
        TransactionManager tm = this.transactionManagerSupplier.get();
        try {
            tm.setTransactionTimeout(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int priority() {
        return 0;
    }

    public Set<ServiceName> dependencies() {
        return Collections.singleton(this.serviceName);
    }

    public void start(StartContext context) throws StartException {
        this.txnRollbackSetupActionConsumer.accept(this);
    }

    public void stop(StopContext context) {
        this.txnRollbackSetupActionConsumer.accept(null);
    }

    private boolean changeDepth(int increment) {
        Holder holder = depth.get();
        if (holder == null) {
            holder = new Holder();
            try {
                TransactionManager tm = this.transactionManagerSupplier.get();
                holder.actuallyCleanUp = !this.isTransactionActive(tm, tm.getStatus());
                depth.set(holder);
            }
            catch (Exception e) {
                TransactionLogger.ROOT_LOGGER.unableToGetTransactionStatus(e);
            }
        }
        holder.depth += increment;
        if (holder.depth == 0) {
            depth.set(null);
            return holder.actuallyCleanUp;
        }
        return false;
    }

    private void checkTransactionStatus() {
        try {
            TransactionManager tm = this.transactionManagerSupplier.get();
            int status = tm.getStatus();
            boolean active = this.isTransactionActive(tm, status);
            if (active) {
                try {
                    TransactionLogger.ROOT_LOGGER.transactionStillOpen(status);
                    tm.rollback();
                }
                catch (Exception ex) {
                    TransactionLogger.ROOT_LOGGER.unableToRollBack(ex);
                }
            }
        }
        catch (Exception e) {
            TransactionLogger.ROOT_LOGGER.unableToGetTransactionStatus(e);
        }
    }

    private boolean isTransactionActive(TransactionManager tm, int status) throws SystemException {
        switch (status) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    private static class Holder {
        int depth;
        boolean actuallyCleanUp = true;

        private Holder() {
        }
    }
}

