/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jboss.as.controller.ModuleIdentifierUtil;
import org.jboss.as.server.deployment.module.FilterSpecification;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.filter.PathFilter;

public final class ModuleDependency
implements Serializable {
    private static final long serialVersionUID = 2749276798703740853L;
    private final ModuleLoader moduleLoader;
    private final String identifier;
    private final boolean export;
    private final boolean optional;
    private final List<FilterSpecification> importFilters = new ArrayList<FilterSpecification>();
    private final List<FilterSpecification> exportFilters = new ArrayList<FilterSpecification>();
    private final boolean importServices;
    private final boolean userSpecified;
    private final String reason;

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ModuleDependency [");
        if (this.identifier != null) {
            builder.append("identifier=").append(this.identifier).append(", ");
        }
        if (this.moduleLoader != null) {
            builder.append("moduleLoader=").append(this.moduleLoader).append(", ");
        }
        builder.append("export=").append(this.export).append(", optional=").append(this.optional).append(", importServices=").append(this.importServices);
        if (this.reason != null) {
            builder.append(", ").append("reason=").append(this.reason);
        }
        builder.append("]");
        return builder.toString();
    }

    @Deprecated(forRemoval=true)
    public ModuleDependency(ModuleLoader moduleLoader, String identifier, boolean optional, boolean export, boolean importServices, boolean userSpecified) {
        this(moduleLoader, ModuleIdentifierUtil.parseCanonicalModuleIdentifier((String)identifier), null, optional, export, importServices, userSpecified);
    }

    @Deprecated(forRemoval=true)
    public ModuleDependency(ModuleLoader moduleLoader, String identifier, boolean optional, boolean export, boolean importServices, boolean userSpecified, String reason) {
        this(moduleLoader, ModuleIdentifierUtil.parseCanonicalModuleIdentifier((String)identifier), reason, optional, export, importServices, userSpecified);
    }

    private ModuleDependency(ModuleLoader moduleLoader, String identifier, String reason, boolean optional, boolean export, boolean importServices, boolean userSpecified) {
        this.identifier = identifier;
        this.optional = optional;
        this.export = export;
        this.moduleLoader = moduleLoader;
        this.importServices = importServices;
        this.userSpecified = userSpecified;
        this.reason = reason;
    }

    public ModuleLoader getModuleLoader() {
        return this.moduleLoader;
    }

    public String getDependencyModule() {
        return this.identifier;
    }

    public Optional<String> getReason() {
        if (this.reason != null) {
            return Optional.of(this.reason);
        }
        return Optional.empty();
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean isExport() {
        return this.export;
    }

    public boolean isUserSpecified() {
        return this.userSpecified;
    }

    public void addImportFilter(PathFilter pathFilter, boolean include) {
        this.importFilters.add(new FilterSpecification(pathFilter, include));
    }

    public List<FilterSpecification> getImportFilters() {
        return this.importFilters;
    }

    public void addExportFilter(PathFilter pathFilter, boolean include) {
        this.exportFilters.add(new FilterSpecification(pathFilter, include));
    }

    public List<FilterSpecification> getExportFilters() {
        return this.exportFilters;
    }

    public boolean isImportServices() {
        return this.importServices;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModuleDependency that = (ModuleDependency)o;
        return this.export == that.export && this.optional == that.optional && this.importServices == that.importServices && this.userSpecified == that.userSpecified && Objects.equals(this.moduleLoader, that.moduleLoader) && this.identifier.equals(that.identifier) && this.importFilters.equals(that.importFilters) && this.exportFilters.equals(that.exportFilters);
    }

    public int hashCode() {
        return Objects.hash(this.moduleLoader, this.identifier, this.export, this.optional, this.importFilters, this.exportFilters, this.importServices, this.userSpecified);
    }

    public static final class Builder {
        private final ModuleLoader moduleLoader;
        private final String identifier;
        private boolean export;
        private boolean optional;
        private boolean importServices;
        private boolean userSpecified;
        private String reason;

        public static Builder of(ModuleLoader moduleLoader, String moduleName) {
            return new Builder(moduleLoader, moduleName);
        }

        private Builder(ModuleLoader moduleLoader, String moduleName) {
            this.moduleLoader = moduleLoader;
            this.identifier = ModuleIdentifierUtil.parseCanonicalModuleIdentifier((String)moduleName);
        }

        public Builder setExport(boolean export) {
            this.export = export;
            return this;
        }

        public Builder setImportServices(boolean importServices) {
            this.importServices = importServices;
            return this;
        }

        public Builder setOptional(boolean optional) {
            this.optional = optional;
            return this;
        }

        public Builder setUserSpecified(boolean userSpecified) {
            this.userSpecified = userSpecified;
            return this;
        }

        public Builder setReason(String reason) {
            this.reason = reason;
            return this;
        }

        public ModuleDependency build() {
            return new ModuleDependency(this.moduleLoader, this.identifier, this.reason, this.optional, this.export, this.importServices, this.userSpecified);
        }
    }
}

