/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module.descriptor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.as.server.deployment.module.FilterSpecification;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.modules.DependencySpec;

class ModuleStructureSpec {
    private String moduleName;
    private final List<ModuleDependency> moduleDependencies = new ArrayList<ModuleDependency>();
    private final List<DependencySpec> systemDependencies = new ArrayList<DependencySpec>();
    private final List<ResourceRoot> resourceRoots = new ArrayList<ResourceRoot>();
    private final List<FilterSpecification> exportFilters = new ArrayList<FilterSpecification>();
    private final List<String> exclusions = new ArrayList<String>();
    private final List<String> classTransformers = new ArrayList<String>();
    private final List<String> aliases = new ArrayList<String>();
    private final List<String> annotationModules = new ArrayList<String>();
    private Set<String> excludedSubsystems;
    private boolean localLast = false;

    ModuleStructureSpec() {
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public void addModuleDependency(ModuleDependency dependency) {
        this.moduleDependencies.add(dependency);
    }

    public List<ModuleDependency> getModuleDependencies() {
        return Collections.unmodifiableList(this.moduleDependencies);
    }

    public void addResourceRoot(ResourceRoot resourceRoot) {
        this.resourceRoots.add(resourceRoot);
    }

    public List<ResourceRoot> getResourceRoots() {
        return Collections.unmodifiableList(this.resourceRoots);
    }

    public void addSystemDependency(DependencySpec dependency) {
        this.systemDependencies.add(dependency);
    }

    public List<DependencySpec> getSystemDependencies() {
        return Collections.unmodifiableList(this.systemDependencies);
    }

    public void addAlias(String dependency) {
        this.aliases.add(dependency);
    }

    public List<String> getAliasesList() {
        return Collections.unmodifiableList(this.aliases);
    }

    public void addAnnotationModule(String dependency) {
        this.annotationModules.add(dependency);
    }

    public List<String> getAnnotationModules() {
        return Collections.unmodifiableList(this.annotationModules);
    }

    public List<String> getExclusionsList() {
        return this.exclusions.stream().collect(Collectors.toUnmodifiableList());
    }

    public void addExclusion(String identifier) {
        this.exclusions.add(identifier);
    }

    public List<FilterSpecification> getExportFilters() {
        return this.exportFilters;
    }

    public List<String> getClassTransformers() {
        return this.classTransformers;
    }

    public boolean isLocalLast() {
        return this.localLast;
    }

    public void setLocalLast(boolean localLast) {
        this.localLast = localLast;
    }

    public Set<String> getExcludedSubsystems() {
        return this.excludedSubsystems;
    }

    public void setExcludedSubsystems(Set<String> excludedSubsystems) {
        this.excludedSubsystems = excludedSubsystems;
    }
}

