/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.deployment;

import jakarta.transaction.TransactionScoped;
import jakarta.transaction.Transactional;
import java.util.List;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.jandex.DotName;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;

public class TransactionDependenciesProcessor
implements DeploymentUnitProcessor {
    private static final String JTS_MODULE = "org.jboss.jts";
    private static final String TRANSACTION_API = "jakarta.transaction.api";
    private static final String TRANSACTION_CLIENT = "org.wildfly.transaction.client";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = phaseContext.getDeploymentUnit();
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        ModuleSpecification moduleSpec = (ModuleSpecification)unit.getAttachment(Attachments.MODULE_SPECIFICATION);
        moduleSpec.addSystemDependency(ModuleDependency.Builder.of((ModuleLoader)moduleLoader, (String)TRANSACTION_API).setImportServices(true).build());
        moduleSpec.addSystemDependency(ModuleDependency.Builder.of((ModuleLoader)moduleLoader, (String)TRANSACTION_CLIENT).setImportServices(true).build());
        CompositeIndex compositeIndex = (CompositeIndex)unit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (compositeIndex == null) {
            return;
        }
        List transactionalAnnotations = compositeIndex.getAnnotations(DotName.createSimple((String)Transactional.class.getName()));
        List transactionScopedAnnotations = compositeIndex.getAnnotations(DotName.createSimple((String)TransactionScoped.class.getName()));
        if (!transactionalAnnotations.isEmpty() || !transactionScopedAnnotations.isEmpty()) {
            this.addJTSModuleDependencyToDeployment(unit);
        }
    }

    private void addJTSModuleDependencyToDeployment(DeploymentUnit unit) {
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        ModuleSpecification moduleSpec = (ModuleSpecification)unit.getAttachment(Attachments.MODULE_SPECIFICATION);
        moduleSpec.addSystemDependency(ModuleDependency.Builder.of((ModuleLoader)moduleLoader, (String)JTS_MODULE).setImportServices(true).build());
    }
}

