/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.core.stats.impl;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.dataconversion.internal.JsonSerialization;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=4201)
class QueryMetrics
implements JsonSerialization {
    final LongAdder count = new LongAdder();
    final LongAdder totalTime = new LongAdder();
    final AtomicLong maxTime = new AtomicLong(-1L);
    volatile String slowest = null;
    final ReadWriteLock lock = new ReentrantReadWriteLock();
    final Lock recordLock = this.lock.readLock();
    final Lock summaryLock = this.lock.writeLock();

    public QueryMetrics() {
        this.count.reset();
        this.totalTime.reset();
    }

    @ProtoFactory
    public QueryMetrics(long count, long totalTime, long maxTime, String slowest) {
        this.count.add(count);
        this.totalTime.add(totalTime);
        this.maxTime.set(maxTime);
        this.slowest = slowest;
    }

    @ProtoField(number=1, defaultValue="0")
    long count() {
        return this.count.longValue();
    }

    @ProtoField(number=2, defaultValue="0")
    long totalTime() {
        return this.totalTime.longValue();
    }

    @ProtoField(number=3, defaultValue="0")
    long maxTime() {
        return this.maxTime.get();
    }

    @ProtoField(number=4)
    public String slowest() {
        return this.slowest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    double avg() {
        this.summaryLock.lock();
        try {
            long countValue = this.count.longValue();
            if (countValue == 0L) {
                double d = 0.0;
                return d;
            }
            double d = this.totalTime.doubleValue() / (double)this.count.longValue();
            return d;
        }
        finally {
            this.summaryLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void record(String q, long timeNanos) {
        this.recordLock.lock();
        try {
            this.count.increment();
            this.totalTime.add(timeNanos);
            this.updateMaxQuery(q, timeNanos);
        }
        finally {
            this.recordLock.unlock();
        }
    }

    void record(long timeNanos) {
        this.record(null, timeNanos);
    }

    void clear() {
        this.count.reset();
        this.totalTime.reset();
        this.maxTime.set(0L);
        this.slowest = null;
    }

    private void updateMaxQuery(String q, long time) {
        long localMax = this.maxTime.get();
        while (time > localMax) {
            if (this.maxTime.compareAndSet(localMax, time)) {
                this.slowest = q;
                return;
            }
            localMax = this.maxTime.get();
        }
    }

    public Json toJson() {
        Json object = Json.object().set("count", (Object)this.count()).set("average", (Object)this.avg()).set("max", (Object)this.maxTime());
        if (this.slowest != null) {
            object.set("slowest", (Object)this.slowest());
        }
        return object;
    }
}

