/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.common.reflect.impl;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Member;
import org.hibernate.search.util.common.impl.Throwables;
import org.hibernate.search.util.common.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reflect.spi.ValueCreateHandle;

public final class MethodHandleValueCreateHandle<T>
implements ValueCreateHandle<T> {
    private static final Log log = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final Member member;
    private final MethodHandle delegate;

    public MethodHandleValueCreateHandle(Member member, MethodHandle delegate) {
        this.member = member;
        this.delegate = delegate;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + String.valueOf(this.member) + "]";
    }

    @Override
    public int hashCode() {
        return this.member.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        MethodHandleValueCreateHandle other = (MethodHandleValueCreateHandle)obj;
        return this.member.equals(other.member);
    }

    @Override
    public T create(Object ... arguments) {
        try {
            return (T)this.delegate.invokeWithArguments(arguments);
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw log.errorInvokingStaticMember(this.member, Throwables.safeToString(e, arguments), e, e.getMessage());
        }
    }
}

