/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.syntax;

import org.infinispan.objectfilter.impl.syntax.PrimaryPredicateExpr;
import org.infinispan.objectfilter.impl.syntax.ValueExpr;
import org.infinispan.objectfilter.impl.syntax.Visitor;

public final class ConstantBooleanExpr
implements PrimaryPredicateExpr {
    public static final ConstantBooleanExpr TRUE = new ConstantBooleanExpr(true);
    public static final ConstantBooleanExpr FALSE = new ConstantBooleanExpr(false);
    private final boolean constantValue;

    public static ConstantBooleanExpr forBoolean(boolean value) {
        return value ? TRUE : FALSE;
    }

    private ConstantBooleanExpr(boolean constantValue) {
        this.constantValue = constantValue;
    }

    @Override
    public ValueExpr getChild() {
        return null;
    }

    public boolean getValue() {
        return this.constantValue;
    }

    public ConstantBooleanExpr negate() {
        return this.constantValue ? FALSE : TRUE;
    }

    @Override
    public <T> T acceptVisitor(Visitor<?, ?> visitor) {
        return (T)visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstantBooleanExpr other = (ConstantBooleanExpr)o;
        return this.constantValue == other.constantValue;
    }

    public int hashCode() {
        return this.constantValue ? 1 : 0;
    }

    public String toString() {
        return this.constantValue ? "CONST_TRUE" : "CONST_FALSE";
    }

    @Override
    public void appendQueryString(StringBuilder sb) {
        if (this.constantValue) {
            sb.append("TRUE");
        } else {
            sb.append("FALSE");
        }
    }
}

