/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.federation;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.config.federation.FederationPolicy;
import org.apache.activemq.artemis.utils.Preconditions;

public class FederationAddressPolicyConfiguration
implements FederationPolicy<FederationAddressPolicyConfiguration>,
Serializable {
    private String name;
    private Set<Matcher> includes = new HashSet<Matcher>();
    private Set<Matcher> excludes = new HashSet<Matcher>();
    private Boolean autoDelete;
    private Long autoDeleteDelay;
    private Long autoDeleteMessageCount;
    private int maxHops;
    private String transformerRef;
    private boolean enableDivertBindings;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public FederationAddressPolicyConfiguration setName(String name) {
        this.name = name;
        return this;
    }

    public Set<Matcher> getIncludes() {
        return this.includes;
    }

    public Set<Matcher> getExcludes() {
        return this.excludes;
    }

    public FederationAddressPolicyConfiguration addInclude(Matcher include) {
        this.includes.add(include);
        return this;
    }

    public FederationAddressPolicyConfiguration addExclude(Matcher exclude) {
        this.excludes.add(exclude);
        return this;
    }

    public int getMaxHops() {
        return this.maxHops;
    }

    public FederationAddressPolicyConfiguration setMaxHops(int maxHops) {
        this.maxHops = maxHops;
        return this;
    }

    public Long getAutoDeleteMessageCount() {
        return this.autoDeleteMessageCount;
    }

    public FederationAddressPolicyConfiguration setAutoDeleteMessageCount(Long autoDeleteMessageCount) {
        this.autoDeleteMessageCount = autoDeleteMessageCount;
        return this;
    }

    public Long getAutoDeleteDelay() {
        return this.autoDeleteDelay;
    }

    public FederationAddressPolicyConfiguration setAutoDeleteDelay(Long autoDeleteDelay) {
        this.autoDeleteDelay = autoDeleteDelay;
        return this;
    }

    public Boolean getAutoDelete() {
        return this.autoDelete;
    }

    public FederationAddressPolicyConfiguration setAutoDelete(Boolean autoDelete) {
        this.autoDelete = autoDelete;
        return this;
    }

    public String getTransformerRef() {
        return this.transformerRef;
    }

    public FederationAddressPolicyConfiguration setTransformerRef(String transformerRef) {
        this.transformerRef = transformerRef;
        return this;
    }

    public Boolean isEnableDivertBindings() {
        return this.enableDivertBindings;
    }

    public FederationAddressPolicyConfiguration setEnableDivertBindings(Boolean enableDivertBindings) {
        this.enableDivertBindings = enableDivertBindings;
        return this;
    }

    @Override
    public void encode(ActiveMQBuffer buffer) {
        Preconditions.checkArgument(this.name != null, "name can not be null");
        buffer.writeString(this.name);
        buffer.writeNullableBoolean(this.autoDelete);
        buffer.writeNullableLong(this.autoDeleteDelay);
        buffer.writeNullableLong(this.autoDeleteMessageCount);
        buffer.writeInt(this.maxHops);
        buffer.writeNullableString(this.transformerRef);
        this.encodeMatchers(buffer, this.includes);
        this.encodeMatchers(buffer, this.excludes);
        buffer.writeBoolean(this.enableDivertBindings);
    }

    @Override
    public void decode(ActiveMQBuffer buffer) {
        this.name = buffer.readString();
        this.autoDelete = buffer.readNullableBoolean();
        this.autoDeleteDelay = buffer.readNullableLong();
        this.autoDeleteMessageCount = buffer.readNullableLong();
        this.maxHops = buffer.readInt();
        this.transformerRef = buffer.readNullableString();
        this.includes = new HashSet<Matcher>();
        this.excludes = new HashSet<Matcher>();
        this.decodeMatchers(buffer, this.includes);
        this.decodeMatchers(buffer, this.excludes);
        if (buffer.readableBytes() > 0) {
            this.enableDivertBindings = buffer.readBoolean();
        }
    }

    private void encodeMatchers(ActiveMQBuffer buffer, Set<Matcher> matchers) {
        buffer.writeInt(matchers == null ? 0 : matchers.size());
        if (matchers != null) {
            for (Matcher matcher : matchers) {
                matcher.encode(buffer);
            }
        }
    }

    private void decodeMatchers(ActiveMQBuffer buffer, Set<Matcher> matchers) {
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            Matcher matcher = new Matcher();
            matcher.decode(buffer);
            matchers.add(matcher);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FederationAddressPolicyConfiguration)) {
            return false;
        }
        FederationAddressPolicyConfiguration that = (FederationAddressPolicyConfiguration)o;
        return this.maxHops == that.maxHops && Objects.equals(this.name, that.name) && Objects.equals(this.includes, that.includes) && Objects.equals(this.excludes, that.excludes) && Objects.equals(this.autoDelete, that.autoDelete) && Objects.equals(this.autoDeleteDelay, that.autoDeleteDelay) && Objects.equals(this.autoDeleteMessageCount, that.autoDeleteMessageCount) && Objects.equals(this.transformerRef, that.transformerRef);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.includes, this.excludes, this.autoDelete, this.autoDeleteDelay, this.autoDeleteMessageCount, this.maxHops, this.transformerRef);
    }

    public static class Matcher
    implements Serializable {
        private String addressMatch;
        private String name;

        public String getName() {
            if (this.name == null) {
                return this.addressMatch;
            }
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getAddressMatch() {
            return this.addressMatch;
        }

        public Matcher setAddressMatch(String addressMatch) {
            this.addressMatch = addressMatch;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Matcher)) {
                return false;
            }
            Matcher matcher = (Matcher)o;
            return Objects.equals(this.addressMatch, matcher.addressMatch);
        }

        public int hashCode() {
            return Objects.hash(this.addressMatch);
        }

        public void encode(ActiveMQBuffer buffer) {
            Preconditions.checkArgument(this.addressMatch != null, "addressMatch can not be null");
            buffer.writeString(this.addressMatch);
        }

        public void decode(ActiveMQBuffer buffer) {
            this.addressMatch = buffer.readString();
        }
    }
}

