/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.mwlabs.wscf.model.sagas.arjunacore;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.mw.wsas.exceptions.SystemException;
import com.arjuna.mw.wsas.exceptions.WrongStateException;
import com.arjuna.mw.wscf.exceptions.InvalidParticipantException;
import com.arjuna.mw.wscf.logging.wscfLogger;
import com.arjuna.mw.wscf.model.sagas.exceptions.CancelFailedException;
import com.arjuna.mw.wscf.model.sagas.exceptions.CompensateFailedException;
import com.arjuna.mw.wscf.model.sagas.participants.Participant;
import com.arjuna.mw.wscf.model.sagas.participants.ParticipantWithComplete;
import com.arjuna.mwlabs.wscf.model.sagas.arjunacore.CoordinatorIdImple;
import com.arjuna.webservices.util.ClassLoaderHelper;
import java.io.PrintWriter;

public class ParticipantRecord
extends AbstractRecord {
    private Participant _resourceHandle;
    private long _timeout;
    private CoordinatorIdImple _coordId;
    private boolean _exited = false;
    private boolean _failed = false;
    private boolean _completed = false;

    public ParticipantRecord(Participant theResource, Uid id) {
        super(id, null, 1);
        this._resourceHandle = theResource;
        this._timeout = 0L;
        this._coordId = new CoordinatorIdImple(id);
        if (theResource == null) {
            wscfLogger.i18NLogger.warn_model_sagas_coordinator_arjunacore_ParticipantRecord_1(this.order());
        }
    }

    public boolean propagateOnCommit() {
        return true;
    }

    public int typeIs() {
        return 162;
    }

    public Object value() {
        return this._resourceHandle;
    }

    public void setValue(Object o) {
        wscfLogger.i18NLogger.warn_model_sagas_coordinator_arjunacore_ParticipantRecord_2();
    }

    public int nestedAbort() {
        try {
            if (this._resourceHandle != null) {
                return 8;
            }
            return 8;
        }
        catch (Exception ex6) {
            wscfLogger.i18NLogger.warn_model_sagas_coordinator_arjunacore_ParticipantRecord_3(this.order(), ex6);
            wscfLogger.i18NLogger.warn_unexpectedException(ex6);
            return 8;
        }
    }

    public int nestedCommit() {
        try {
            if (this._resourceHandle != null) {
                return 8;
            }
            return 8;
        }
        catch (Exception ex6) {
            wscfLogger.i18NLogger.warn_model_sagas_coordinator_arjunacore_ParticipantRecord_4(this.order(), ex6);
            wscfLogger.i18NLogger.warn_unexpectedException(ex6);
            return 8;
        }
    }

    public int nestedPrepare() {
        try {
            if (this._resourceHandle != null) {
                return 8;
            }
            return 1;
        }
        catch (Exception e6) {
            wscfLogger.i18NLogger.warn_model_sagas_coordinator_arjunacore_ParticipantRecord_5(this.order(), e6);
            wscfLogger.i18NLogger.warn_unexpectedException(e6);
            return 6;
        }
    }

    public int topLevelAbort() {
        try {
            if (this._resourceHandle != null) {
                try {
                    if (!this._exited) {
                        if (this._completed) {
                            this._resourceHandle.compensate();
                        } else {
                            this._resourceHandle.cancel();
                        }
                    }
                }
                catch (InvalidParticipantException ex) {
                    return 8;
                }
                catch (WrongStateException ex) {
                    return 6;
                }
                catch (CancelFailedException ex) {
                    return 6;
                }
                catch (CompensateFailedException ex) {
                    return 6;
                }
                catch (SystemException ex) {
                    return 8;
                }
                if (this._failed) {
                    return 6;
                }
                return 7;
            }
            return 8;
        }
        catch (Exception ex6) {
            wscfLogger.i18NLogger.warn_model_sagas_coordinator_arjunacore_ParticipantRecord_6(this.order(), ex6);
            wscfLogger.i18NLogger.warn_unexpectedException(ex6);
            return 8;
        }
    }

    public int topLevelCommit() {
        try {
            if (this._resourceHandle != null) {
                try {
                    if (!this._exited) {
                        this._resourceHandle.close();
                    }
                }
                catch (InvalidParticipantException ex) {
                    return 8;
                }
                catch (WrongStateException ex) {
                    return 6;
                }
                catch (SystemException ex) {
                    return 8;
                }
                if (this._failed) {
                    return 6;
                }
                return 7;
            }
            return 8;
        }
        catch (Exception ex6) {
            wscfLogger.i18NLogger.warn_model_sagas_coordinator_arjunacore_ParticipantRecord_7(this.order(), ex6);
            wscfLogger.i18NLogger.warn_unexpectedException(ex6);
            return 8;
        }
    }

    public int topLevelPrepare() {
        try {
            if (this._failed) {
                return 6;
            }
            if (this._exited) {
                return 2;
            }
            return this._completed ? 0 : 1;
        }
        catch (Exception e6) {
            wscfLogger.i18NLogger.warn_model_sagas_coordinator_arjunacore_ParticipantRecord_8(this.order(), e6);
            wscfLogger.i18NLogger.warn_unexpectedException(e6);
            return 0;
        }
    }

    public int nestedOnePhaseCommit() {
        try {
            if (this._resourceHandle != null) {
                return 8;
            }
            return 8;
        }
        catch (Exception ex6) {
            wscfLogger.i18NLogger.warn_model_sagas_coordinator_arjunacore_ParticipantRecord_9(this.order(), ex6);
            wscfLogger.i18NLogger.warn_unexpectedException(ex6);
            return 8;
        }
    }

    public int topLevelOnePhaseCommit() {
        try {
            if (this._resourceHandle != null) {
                if (this.isActive()) {
                    return 10;
                }
                try {
                    if (!this._exited) {
                        this._resourceHandle.close();
                    }
                }
                catch (InvalidParticipantException ex) {
                    return 10;
                }
                catch (WrongStateException ex) {
                    return 6;
                }
                catch (SystemException ex) {
                    return 8;
                }
                if (this._failed) {
                    return 6;
                }
                return 7;
            }
            return 10;
        }
        catch (Exception ex6) {
            wscfLogger.i18NLogger.warn_model_sagas_coordinator_arjunacore_ParticipantRecord_10(this.order(), ex6);
            return 8;
        }
    }

    public boolean forgetHeuristic() {
        try {
            if (this._resourceHandle != null) {
                try {
                    if (!this._exited) {
                        this._resourceHandle.forget();
                    }
                }
                catch (InvalidParticipantException ex) {
                    return false;
                }
                catch (WrongStateException ex) {
                    return false;
                }
                catch (SystemException ex) {
                    return false;
                }
                return true;
            }
            wscfLogger.i18NLogger.warn_model_sagas_coordinator_arjunacore_ParticipantRecord_11(this.order());
        }
        catch (Exception e) {
            wscfLogger.i18NLogger.warn_model_sagas_coordinator_arjunacore_ParticipantRecord_12(this.order(), e);
        }
        return false;
    }

    public boolean complete() {
        boolean result;
        block8: {
            result = false;
            try {
                if (this._resourceHandle == null) break block8;
                try {
                    if (this.isActive()) {
                        if (this._resourceHandle instanceof ParticipantWithComplete) {
                            ((ParticipantWithComplete)this._resourceHandle).complete();
                            this.completed();
                        }
                        result = true;
                        break block8;
                    }
                    result = true;
                }
                catch (InvalidParticipantException invalidParticipantException) {
                }
                catch (WrongStateException wrongStateException) {
                }
                catch (SystemException systemException) {}
            }
            catch (Exception ex6) {
                wscfLogger.i18NLogger.warn_model_sagas_coordinator_arjunacore_ParticipantRecord_13(this.order(), ex6);
            }
        }
        return result;
    }

    public static AbstractRecord create() {
        return new ParticipantRecord();
    }

    public void print(PrintWriter strm) {
        super.print(strm);
        strm.print("ParticipantRecord");
        strm.print(this._resourceHandle);
    }

    public boolean restore_state(InputObjectState os, int t) {
        boolean result = super.restore_state(os, t);
        if (result) {
            try {
                String resourcehandleImplClassName = os.unpackString();
                Class clazz = ClassLoaderHelper.forName(ParticipantRecord.class, resourcehandleImplClassName);
                this._resourceHandle = (Participant)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                result = this._resourceHandle.restore_state(os);
                if (result) {
                    this._timeout = os.unpackLong();
                    this._completed = os.unpackBoolean();
                    this._exited = os.unpackBoolean();
                    if (this._exited) {
                        this._failed = os.unpackBoolean();
                    }
                }
            }
            catch (Exception ex) {
                wscfLogger.i18NLogger.warn_model_sagas_coordinator_arjunacore_ParticipantRecord_14(ex);
                result = false;
            }
        }
        return result;
    }

    public boolean save_state(OutputObjectState os, int t) {
        boolean result = super.save_state(os, t);
        if (result) {
            try {
                os.packString(this._resourceHandle.getClass().getName());
                result = this._resourceHandle.save_state(os);
                if (result) {
                    os.packLong(this._timeout);
                    os.packBoolean(this._completed);
                    os.packBoolean(this._exited);
                    if (this._exited) {
                        os.packBoolean(this._failed);
                    }
                }
            }
            catch (Exception ex) {
                wscfLogger.i18NLogger.warn_model_sagas_coordinator_arjunacore_ParticipantRecord_15(ex);
                result = false;
            }
        }
        return result;
    }

    public String type() {
        return "/StateManager/AbstractRecord/WSCF/ArjunaCore/ParticipantRecord";
    }

    public boolean doSave() {
        return !this._exited || this._failed;
    }

    public void merge(AbstractRecord a) {
    }

    public void alter(AbstractRecord a) {
    }

    public boolean shouldAdd(AbstractRecord a) {
        return false;
    }

    public boolean shouldAlter(AbstractRecord a) {
        return false;
    }

    public boolean shouldMerge(AbstractRecord a) {
        return false;
    }

    public boolean shouldReplace(AbstractRecord rec) {
        return false;
    }

    public final void delist(boolean failed) {
        this._exited = true;
        this._failed = failed;
    }

    public final void completed() {
        this.synchronizationLock.lock();
        try {
            this._completed = true;
        }
        finally {
            this.synchronizationLock.unlock();
        }
    }

    public final boolean isActive() {
        this.synchronizationLock.lock();
        try {
            boolean bl = !this._completed && !this._exited;
            return bl;
        }
        finally {
            this.synchronizationLock.unlock();
        }
    }

    public final boolean isParticipantCompletion() {
        return !(this._resourceHandle instanceof ParticipantWithComplete);
    }

    public ParticipantRecord() {
        this._resourceHandle = null;
        this._timeout = 0L;
        this._coordId = null;
    }
}

