/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client.header;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.microprofile.rest.client.RestClientDefinitionException;

public class HeaderUtils {
    private HeaderUtils() {
    }

    public static MethodHandle createMethodHandle(Method method, Object clientProxy) {
        try {
            Class<?> proxyType = method.getDeclaringClass();
            return MethodHandles.lookup().findSpecial(proxyType, method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()), proxyType).bindTo(clientProxy);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RestClientDefinitionException("Failed to generate method handle for " + String.valueOf(method), (Throwable)e);
        }
    }

    public static Method resolveMethod(String methodSpecifier, Class<?> interfaceClass, String headerName) {
        Class<?> clazz;
        String methodName;
        int lastDot = methodSpecifier.lastIndexOf(46);
        if (lastDot == methodSpecifier.length()) {
            throw new RestClientDefinitionException("Invalid string to specify method: " + methodSpecifier + " for header: '" + headerName + "' on class " + interfaceClass.getCanonicalName());
        }
        if (lastDot > -1) {
            methodName = methodSpecifier.substring(lastDot + 1);
            String className = methodSpecifier.substring(0, lastDot);
            ClassLoader loader = System.getSecurityManager() == null ? Thread.currentThread().getContextClassLoader() : AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
            try {
                clazz = Class.forName(className, true, loader);
            }
            catch (ClassNotFoundException e) {
                throw new RestClientDefinitionException("No class '" + className + "' found for filling header '" + headerName + " on " + interfaceClass.getCanonicalName(), (Throwable)e);
            }
        } else {
            clazz = interfaceClass;
            methodName = methodSpecifier;
        }
        Method method = null;
        boolean resolved = false;
        try {
            method = clazz.getMethod(methodName, new Class[0]);
            resolved = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (!resolved) {
            try {
                method = clazz.getMethod(methodName, String.class);
                resolved = true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (resolved) {
            return method;
        }
        throw new RestClientDefinitionException("Could not resolve method '" + methodSpecifier + "' for filling header '" + headerName + " on " + interfaceClass.getCanonicalName());
    }

    public static List<String> castListToListOfStrings(List<?> result) {
        return result.stream().map(val -> val instanceof String ? (String)val : String.valueOf(val)).collect(Collectors.toList());
    }
}

