/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.server;

import java.util.ArrayList;
import java.util.function.Function;
import org.jboss.as.clustering.naming.BinderServiceInstaller;
import org.jboss.as.controller.ServiceNameFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.deployment.JndiName;
import org.jboss.msc.service.ServiceName;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class DefaultUnaryServiceInstallerProvider<T>
implements Function<String, Iterable<ServiceInstaller>> {
    private final UnaryServiceDescriptor<T> descriptor;
    private final Function<String, JndiName> jndiNameFactory;

    protected DefaultUnaryServiceInstallerProvider(UnaryServiceDescriptor<T> descriptor, Function<String, JndiName> jndiNameFactory) {
        this.descriptor = descriptor;
        this.jndiNameFactory = jndiNameFactory;
    }

    @Override
    public Iterable<ServiceInstaller> apply(String value) {
        ServiceName name = ServiceNameFactory.resolveServiceName(this.descriptor, null);
        ArrayList<ServiceInstaller> installers = new ArrayList<ServiceInstaller>(2);
        installers.add((ServiceInstaller)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((ServiceDependency)ServiceDependency.on(this.descriptor, (String)value)).provides(name)).build());
        if (!value.equals("default")) {
            ContextNames.BindInfo binding = ContextNames.bindInfoFor((String)this.jndiNameFactory.apply("default").getAbsoluteName());
            installers.add((ServiceInstaller)new BinderServiceInstaller(binding, name));
        }
        return installers;
    }
}

