/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import jakarta.transaction.TransactionManager;
import jakarta.transaction.TransactionSynchronizationRegistry;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.infinispan.Cache;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.configuration.cache.TransactionConfigurationBuilder;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.lookup.TransactionSynchronizationRegistryLookup;
import org.infinispan.transaction.tm.EmbeddedTransactionManager;
import org.jboss.as.clustering.controller.DurationAttributeDefinition;
import org.jboss.as.clustering.controller.EnumAttributeDefinition;
import org.jboss.as.clustering.infinispan.subsystem.BinaryServiceDescriptorFactory;
import org.jboss.as.clustering.infinispan.subsystem.ComponentResourceRegistration;
import org.jboss.as.clustering.infinispan.subsystem.ConfigurationResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.TransactionMode;
import org.jboss.as.clustering.infinispan.tx.InfinispanXAResourceRecovery;
import org.jboss.as.clustering.infinispan.tx.TransactionManagerProvider;
import org.jboss.as.clustering.infinispan.tx.TransactionSynchronizationRegistryProvider;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.RequirementServiceBuilder;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.capability.BinaryCapabilityNameResolver;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.dmr.ModelNode;
import org.jboss.tm.XAResourceRecovery;
import org.jboss.tm.XAResourceRecoveryRegistry;
import org.wildfly.clustering.infinispan.service.InfinispanServiceDescriptor;
import org.wildfly.common.function.Functions;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.service.descriptor.NullaryServiceDescriptor;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.capability.ResourceCapabilityReference;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;
import org.wildfly.transaction.client.ContextTransactionManager;

public class TransactionResourceDefinitionRegistrar
extends ConfigurationResourceDefinitionRegistrar<TransactionConfiguration, TransactionConfigurationBuilder>
implements ResourceServiceConfigurator {
    static final BinaryServiceDescriptor<TransactionConfiguration> SERVICE_DESCRIPTOR = BinaryServiceDescriptorFactory.createServiceDescriptor(ComponentResourceRegistration.TRANSACTION, TransactionConfiguration.class);
    private static final RuntimeCapability<Void> CAPABILITY = RuntimeCapability.Builder.of(SERVICE_DESCRIPTOR).setDynamicNameMapper((Function)BinaryCapabilityNameResolver.GRANDPARENT_PARENT).setAllowMultipleRegistrations(true).build();
    static final EnumAttributeDefinition<LockingMode> LOCKING = new EnumAttributeDefinition.Builder("locking", (Enum)LockingMode.PESSIMISTIC).build();
    static final EnumAttributeDefinition<TransactionMode> MODE = new EnumAttributeDefinition.Builder("mode", (Enum)TransactionMode.NONE).build();
    static final DurationAttributeDefinition STOP_TIMEOUT = new DurationAttributeDefinition.Builder("stop-timeout", ChronoUnit.MILLIS).setDefaultValue(Duration.ofSeconds(10L)).build();
    static final DurationAttributeDefinition COMPLETE_TIMEOUT = new DurationAttributeDefinition.Builder("complete-timeout", ChronoUnit.MILLIS).setDefaultValue(Duration.ofMinutes(1L)).build();
    static final NullaryServiceDescriptor<Void> LOCAL_TRANSACTION_PROVIDER = NullaryServiceDescriptor.of((String)"org.wildfly.transactions.global-default-local-provider", Void.class);
    static final NullaryServiceDescriptor<TransactionSynchronizationRegistry> TRANSACTION_SYNCHRONIZATION_REGISTRY = NullaryServiceDescriptor.of((String)"org.wildfly.transactions.transaction-synchronization-registry", TransactionSynchronizationRegistry.class);
    static final NullaryServiceDescriptor<XAResourceRecoveryRegistry> XA_RESOURCE_RECOVERY_REGISTRY = NullaryServiceDescriptor.of((String)"org.wildfly.transactions.xa-resource-recovery-registry", XAResourceRecoveryRegistry.class);
    private static final ResourceCapabilityReference<Cache<?, ?>> CACHE = ResourceCapabilityReference.builder(CAPABILITY, (BinaryServiceDescriptor)InfinispanServiceDescriptor.CACHE).withRequirementNameResolver((Function)BinaryCapabilityNameResolver.GRANDPARENT_PARENT).build();
    private static final ResourceCapabilityReference<Void> LOCAL_TRANSACTION_PROVIDER_REFERENCE = ResourceCapabilityReference.builder(CAPABILITY, LOCAL_TRANSACTION_PROVIDER).when(MODE, (Predicate)new TransactionModeFilter(EnumSet.complementOf(EnumSet.of(TransactionMode.NONE, TransactionMode.BATCH)))).build();
    private static final ResourceCapabilityReference<TransactionSynchronizationRegistry> TRANSACTION_SYNCHRONIZATION_REGISTRY_REFERENCE = ResourceCapabilityReference.builder(CAPABILITY, TRANSACTION_SYNCHRONIZATION_REGISTRY).when(MODE, (Predicate)new TransactionModeFilter(TransactionMode.NON_XA)).build();
    private static final ResourceCapabilityReference<XAResourceRecoveryRegistry> XA_RESOURCE_RECOVERY_REGISTRY_REFERENCE = ResourceCapabilityReference.builder(CAPABILITY, XA_RESOURCE_RECOVERY_REGISTRY).when(MODE, (Predicate)new TransactionModeFilter(TransactionMode.FULL_XA)).build();

    TransactionResourceDefinitionRegistrar() {
        super(new ConfigurationResourceDefinitionRegistrar.Configurator<TransactionConfiguration>(){

            @Override
            public ResourceRegistration getResourceRegistration() {
                return ComponentResourceRegistration.TRANSACTION;
            }

            @Override
            public RuntimeCapability<Void> getCapability() {
                return CAPABILITY;
            }
        });
    }

    @Override
    public ResourceDescriptor.Builder apply(ResourceDescriptor.Builder builder) {
        return (ResourceDescriptor.Builder)((ResourceDescriptor.Builder)super.apply(builder).addAttributes(List.of(LOCKING, MODE, STOP_TIMEOUT, COMPLETE_TIMEOUT))).addResourceCapabilityReferences(List.of(CACHE, LOCAL_TRANSACTION_PROVIDER_REFERENCE, TRANSACTION_SYNCHRONIZATION_REGISTRY_REFERENCE, XA_RESOURCE_RECOVERY_REGISTRY_REFERENCE));
    }

    @Override
    public ResourceOperationRuntimeHandler get() {
        return ResourceOperationRuntimeHandler.combine((ResourceOperationRuntimeHandler[])new ResourceOperationRuntimeHandler[]{super.get(), ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this)});
    }

    public ServiceDependency<TransactionConfigurationBuilder> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        final TransactionMode mode = (TransactionMode)MODE.resolve(context, model);
        final LockingMode locking = (LockingMode)LOCKING.resolve(context, model);
        final Duration stopTimeout = STOP_TIMEOUT.resolve(context, model);
        final Duration transactionTimeout = COMPLETE_TIMEOUT.resolve(context, model);
        final ServiceDependency localTransactionProvider = (ServiceDependency)LOCAL_TRANSACTION_PROVIDER_REFERENCE.resolve(context, model);
        final ServiceDependency tsr = (ServiceDependency)TRANSACTION_SYNCHRONIZATION_REGISTRY_REFERENCE.resolve(context, model);
        return new ServiceDependency<TransactionConfigurationBuilder>(){

            public void accept(RequirementServiceBuilder<?> builder) {
                localTransactionProvider.accept(builder);
                tsr.accept(builder);
            }

            public TransactionConfigurationBuilder get() {
                TransactionConfigurationBuilder builder = new ConfigurationBuilder().transaction().lockingMode(locking).cacheStopTimeout(stopTimeout.toMillis(), TimeUnit.MILLISECONDS).completedTxTimeout(transactionTimeout.toMillis()).transactionMode(mode == TransactionMode.NONE ? org.infinispan.transaction.TransactionMode.NON_TRANSACTIONAL : org.infinispan.transaction.TransactionMode.TRANSACTIONAL).useSynchronization(mode == TransactionMode.NON_XA).recovery().enabled(mode == TransactionMode.FULL_XA).transaction();
                if (mode != TransactionMode.NONE) {
                    builder.transactionManagerLookup((TransactionManagerLookup)new TransactionManagerProvider((TransactionManager)(mode == TransactionMode.BATCH ? EmbeddedTransactionManager.getInstance() : ContextTransactionManager.getInstance())));
                }
                if (tsr.isPresent()) {
                    builder.transactionSynchronizationRegistryLookup((TransactionSynchronizationRegistryLookup)new TransactionSynchronizationRegistryProvider((TransactionSynchronizationRegistry)tsr.get()));
                }
                return builder;
            }
        };
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        final ServiceDependency registry = (ServiceDependency)XA_RESOURCE_RECOVERY_REGISTRY_REFERENCE.resolve(context, model);
        if (registry.isEmpty()) {
            return new ResourceServiceInstaller(){

                public Consumer<OperationContext> install(OperationContext context) {
                    return Functions.discardingConsumer();
                }
            };
        }
        ServiceDependency factory = ((ServiceDependency)CACHE.resolve(context, model)).map(InfinispanXAResourceRecovery::new);
        Consumer<XAResourceRecovery> start = new Consumer<XAResourceRecovery>(){

            @Override
            public void accept(XAResourceRecovery recovery) {
                ((XAResourceRecoveryRegistry)registry.get()).addXAResourceRecovery(recovery);
            }
        };
        Consumer<XAResourceRecovery> stop = new Consumer<XAResourceRecovery>(){

            @Override
            public void accept(XAResourceRecovery recovery) {
                ((XAResourceRecoveryRegistry)registry.get()).removeXAResourceRecovery(recovery);
            }
        };
        return (ResourceServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((ServiceDependency)factory).requires(List.of(registry))).onStart((Consumer)start)).onStop((Consumer)stop)).build();
    }

    private static class TransactionModeFilter
    implements Predicate<TransactionMode> {
        private final Set<TransactionMode> modes;

        TransactionModeFilter(TransactionMode mode) {
            this(EnumSet.of(mode));
        }

        TransactionModeFilter(Set<TransactionMode> modes) {
            this.modes = modes;
        }

        @Override
        public boolean test(TransactionMode value) {
            return this.modes.contains((Object)value);
        }
    }
}

