/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.commons.configuration.attributes.AttributeCopier;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeParser;
import org.infinispan.commons.configuration.attributes.AttributeSerializer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.AttributeValidator;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.commons.configuration.io.ConfigurationWriter;
import org.infinispan.commons.util.TimeQuantity;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.BackupForConfiguration;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.xsite.spi.XSiteEntryMergePolicy;
import org.infinispan.xsite.spi.XSiteMergePolicy;

public class SitesConfiguration
extends ConfigurationElement<SitesConfiguration> {
    public static final AttributeDefinition<XSiteEntryMergePolicy> MERGE_POLICY = AttributeDefinition.builder((Enum)Attribute.MERGE_POLICY, (Object)XSiteMergePolicy.DEFAULT, XSiteEntryMergePolicy.class).copier((AttributeCopier)MergePolicyAttributeUtil.INSTANCE).parser((AttributeParser)MergePolicyAttributeUtil.INSTANCE).serializer((AttributeSerializer)MergePolicyAttributeUtil.INSTANCE).immutable().build();
    public static final AttributeDefinition<TimeQuantity> MAX_CLEANUP_DELAY = AttributeDefinition.builder((Enum)Attribute.MAX_CLEANUP_DELAY, (Object)TimeQuantity.valueOf((String)"30s")).parser(TimeQuantity.PARSER).validator(AttributeValidator.greaterThanZero((Enum)Attribute.MAX_CLEANUP_DELAY)).immutable().build();
    public static final AttributeDefinition<Integer> TOMBSTONE_MAP_SIZE = AttributeDefinition.builder((Enum)Attribute.TOMBSTONE_MAP_SIZE, (Object)512000).validator(AttributeValidator.greaterThanZero((Enum)Attribute.TOMBSTONE_MAP_SIZE)).immutable().build();
    private final BackupForConfiguration backupFor;
    private final List<BackupConfiguration> allBackups;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(SitesConfiguration.class, new AttributeDefinition[]{MERGE_POLICY, MAX_CLEANUP_DELAY, TOMBSTONE_MAP_SIZE});
    }

    public SitesConfiguration(AttributeSet attributes, List<BackupConfiguration> allBackups, BackupForConfiguration backupFor) {
        super((Enum)Element.SITES, attributes, new ConfigurationElement[]{ConfigurationElement.list((Enum)Element.BACKUPS, allBackups), backupFor});
        this.allBackups = List.copyOf(allBackups);
        this.backupFor = backupFor;
    }

    @Deprecated(forRemoval=true, since="14.0")
    public boolean disableBackups() {
        return false;
    }

    public List<BackupConfiguration> allBackups() {
        return this.allBackups;
    }

    public Stream<BackupConfiguration> allBackupsStream() {
        return this.allBackups.stream();
    }

    @Deprecated(forRemoval=true, since="14.0")
    public List<BackupConfiguration> enabledBackups() {
        return this.allBackups();
    }

    @Deprecated(forRemoval=true, since="14.0")
    public Stream<BackupConfiguration> enabledBackupStream() {
        return this.allBackupsStream();
    }

    public BackupForConfiguration backupFor() {
        return this.backupFor;
    }

    public BackupFailurePolicy getFailurePolicy(String siteName) {
        for (BackupConfiguration bc : this.allBackups) {
            if (!bc.site().equals(siteName)) continue;
            return bc.backupFailurePolicy();
        }
        throw new IllegalStateException("There must be a site configured for " + siteName);
    }

    @Deprecated(forRemoval=true, since="14.0")
    public boolean hasInUseBackup(String siteName) {
        return this.allBackups.stream().anyMatch(bc -> bc.site().equals(siteName));
    }

    @Deprecated(forRemoval=true, since="14.0")
    public boolean hasEnabledBackups() {
        return this.hasBackups();
    }

    public boolean hasBackups() {
        return !this.allBackups.isEmpty();
    }

    public boolean hasSyncEnabledBackups() {
        return this.allBackupsStream().anyMatch(BackupConfiguration::isSyncBackup);
    }

    public Stream<BackupConfiguration> syncBackupsStream() {
        return this.allBackupsStream().filter(BackupConfiguration::isSyncBackup);
    }

    public boolean hasAsyncEnabledBackups() {
        return this.allBackupsStream().anyMatch(BackupConfiguration::isAsyncBackup);
    }

    public Stream<BackupConfiguration> asyncBackupsStream() {
        return this.allBackupsStream().filter(BackupConfiguration::isAsyncBackup);
    }

    @Deprecated(forRemoval=true)
    public Set<String> inUseBackupSites() {
        return this.allBackups.stream().map(BackupConfiguration::site).collect(Collectors.toSet());
    }

    public XSiteEntryMergePolicy<?, ?> mergePolicy() {
        return (XSiteEntryMergePolicy)this.attributes.attribute(MERGE_POLICY).get();
    }

    public long maxTombstoneCleanupDelay() {
        return ((TimeQuantity)this.attributes.attribute(MAX_CLEANUP_DELAY).get()).longValue();
    }

    public int tombstoneMapSize() {
        return (Integer)this.attributes.attribute(TOMBSTONE_MAP_SIZE).get();
    }

    private static enum MergePolicyAttributeUtil implements AttributeCopier<XSiteEntryMergePolicy>,
    AttributeSerializer<XSiteEntryMergePolicy>,
    AttributeParser<XSiteEntryMergePolicy>
    {
        INSTANCE;


        public XSiteEntryMergePolicy copyAttribute(XSiteEntryMergePolicy value) {
            if (value == null) {
                return null;
            }
            if (value instanceof XSiteMergePolicy) {
                return ((XSiteMergePolicy)value).getInstance();
            }
            XSiteMergePolicy enumPolicy = XSiteMergePolicy.fromInstance(value);
            return enumPolicy == null ? (XSiteEntryMergePolicy)Util.getInstance(value.getClass()) : enumPolicy.getInstance();
        }

        public void serialize(ConfigurationWriter writer, String name, XSiteEntryMergePolicy value) {
            XSiteMergePolicy enumPolicy = XSiteMergePolicy.fromInstance(value);
            if (enumPolicy != null) {
                writer.writeAttribute(name, enumPolicy.name());
            } else {
                INSTANCE_CLASS_NAME.serialize(writer, name, (Object)value);
            }
        }

        public XSiteEntryMergePolicy parse(Class<?> klass, String value) {
            return XSiteMergePolicy.instanceFromString(value, null);
        }
    }
}

