/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.search.definition.binding.builtin;

import java.lang.invoke.MethodHandles;
import java.util.Optional;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.engine.search.common.ValueModel;
import org.hibernate.search.engine.search.projection.definition.spi.ConstantProjectionDefinition;
import org.hibernate.search.engine.search.projection.definition.spi.FieldProjectionDefinition;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.search.definition.binding.ProjectionBinder;
import org.hibernate.search.mapper.pojo.search.definition.binding.ProjectionBindingContext;
import org.hibernate.search.mapper.pojo.search.definition.binding.ProjectionBindingMultiContext;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class FieldProjectionBinder
implements ProjectionBinder {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String fieldPathOrNull;
    private ValueModel valueModel = ValueModel.MAPPING;

    public static FieldProjectionBinder create() {
        return FieldProjectionBinder.create(null);
    }

    public static FieldProjectionBinder create(String fieldPath) {
        return new FieldProjectionBinder(fieldPath);
    }

    private FieldProjectionBinder(String fieldPathOrNull) {
        this.fieldPathOrNull = fieldPathOrNull;
    }

    @Deprecated
    public FieldProjectionBinder valueConvert(ValueConvert valueConvert) {
        return this.valueModel(ValueConvert.toValueModel((ValueConvert)valueConvert));
    }

    public FieldProjectionBinder valueModel(ValueModel valueModel) {
        this.valueModel = valueModel;
        return this;
    }

    @Override
    public void bind(ProjectionBindingContext context) {
        Optional<? extends ProjectionBindingMultiContext> multiOptional = context.multi();
        String fieldPath = this.fieldPathOrFail(context);
        if (multiOptional.isPresent()) {
            ProjectionBindingMultiContext multi = multiOptional.get();
            this.bind(context, multi, fieldPath, multi.containerElement().rawType());
        } else {
            this.bind(context, fieldPath, context.constructorParameter().rawType());
        }
    }

    private <T> void bind(ProjectionBindingContext context, String fieldPath, Class<T> constructorParameterType) {
        context.definition(constructorParameterType, context.isIncluded(fieldPath) ? BeanHolder.of((Object)new FieldProjectionDefinition.SingleValued(fieldPath, constructorParameterType, this.valueModel)) : ConstantProjectionDefinition.nullValue());
    }

    private <T> void bind(ProjectionBindingContext context, ProjectionBindingMultiContext multi, String fieldPath, Class<T> containerElementType) {
        multi.definition(containerElementType, context.isIncluded(fieldPath) ? BeanHolder.of((Object)new FieldProjectionDefinition.MultiValued(fieldPath, containerElementType, this.valueModel)) : ConstantProjectionDefinition.emptyList());
    }

    private String fieldPathOrFail(ProjectionBindingContext context) {
        if (this.fieldPathOrNull != null) {
            return this.fieldPathOrNull;
        }
        Optional<String> paramName = context.constructorParameter().name();
        if (!paramName.isPresent()) {
            throw log.missingParameterNameForFieldProjectionInProjectionConstructor();
        }
        return paramName.get();
    }
}

