/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.TopologyMember;
import org.apache.activemq.artemis.core.server.NodeLocator;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.utils.ConcurrentUtil;

public class AnyNodeLocatorForReplication
extends NodeLocator {
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final ActiveMQServerImpl server;
    private final long retryReplicationWait;
    Map<String, Pair<TransportConfiguration, TransportConfiguration>> untriedConnectors = new HashMap<String, Pair<TransportConfiguration, TransportConfiguration>>();
    Map<String, Pair<TransportConfiguration, TransportConfiguration>> triedConnectors = new HashMap<String, Pair<TransportConfiguration, TransportConfiguration>>();
    private String nodeID;

    public AnyNodeLocatorForReplication(NodeLocator.BackupRegistrationListener backupRegistrationListener, ActiveMQServerImpl server, long retryReplicationWait) {
        super(backupRegistrationListener);
        this.server = server;
        this.retryReplicationWait = retryReplicationWait;
    }

    @Override
    public void locateNode() throws ActiveMQException {
        this.locateNode(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void locateNode(long timeout) throws ActiveMQException {
        block8: {
            try {
                this.lock.lock();
                if (!this.untriedConnectors.isEmpty()) break block8;
                try {
                    if (timeout != -1L) {
                        ConcurrentUtil.await((Condition)this.condition, (long)timeout);
                    } else {
                        while (this.untriedConnectors.isEmpty()) {
                            this.condition.await(this.retryReplicationWait, TimeUnit.MILLISECONDS);
                            this.untriedConnectors.putAll(this.triedConnectors);
                            this.triedConnectors.clear();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeUP(TopologyMember topologyMember, boolean last) {
        try {
            this.lock.lock();
            Pair connector = new Pair((Object)topologyMember.getPrimary(), (Object)topologyMember.getBackup());
            if (this.server.checkBrokerIsNotColocated(topologyMember.getNodeId())) {
                this.untriedConnectors.put(topologyMember.getNodeId(), (Pair<TransportConfiguration, TransportConfiguration>)connector);
                this.condition.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeDown(long eventUID, String nodeID) {
        try {
            this.lock.lock();
            this.untriedConnectors.putAll(this.triedConnectors);
            this.triedConnectors.clear();
            if (!this.untriedConnectors.isEmpty()) {
                this.condition.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public String getNodeID() {
        return this.nodeID;
    }

    @Override
    public Pair<TransportConfiguration, TransportConfiguration> getPrimaryConfiguration() {
        try {
            this.lock.lock();
            Iterator<String> iterator = this.untriedConnectors.keySet().iterator();
            if (iterator.hasNext()) {
                this.nodeID = iterator.next();
            }
            Pair<TransportConfiguration, TransportConfiguration> pair = this.untriedConnectors.get(this.nodeID);
            return pair;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void notifyRegistrationFailed(boolean alreadyReplicating) {
        try {
            this.lock.lock();
            Pair<TransportConfiguration, TransportConfiguration> tc = this.untriedConnectors.remove(this.nodeID);
            if (tc != null) {
                this.triedConnectors.put(this.nodeID, tc);
            }
        }
        finally {
            this.lock.unlock();
        }
        super.notifyRegistrationFailed(alreadyReplicating);
    }
}

