/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.Arrays;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.BasicPluralJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class MultiKeyLoadHelper {
    private MultiKeyLoadHelper() {
    }

    public static boolean supportsSqlArrayType(Dialect dialect) {
        return dialect.useArrayForMultiValuedParameters();
    }

    public static JdbcMapping resolveArrayJdbcMapping(BasicType<?> arrayBasicType, JdbcMapping keyMapping, Class<?> arrayClass, SessionFactoryImplementor sessionFactory) {
        if (arrayBasicType != null) {
            return arrayBasicType;
        }
        TypeConfiguration typeConfiguration = sessionFactory.getTypeConfiguration();
        JavaTypeRegistry javaTypeRegistry = typeConfiguration.getJavaTypeRegistry();
        JavaType rawArrayJavaType = javaTypeRegistry.resolveDescriptor(arrayClass);
        if (!(rawArrayJavaType instanceof BasicPluralJavaType)) {
            throw new IllegalArgumentException("Expecting BasicPluralJavaType for array class `" + arrayClass.getName() + "`, but got `" + String.valueOf(rawArrayJavaType) + "`");
        }
        BasicPluralJavaType arrayJavaType = (BasicPluralJavaType)((Object)rawArrayJavaType);
        return arrayJavaType.resolveType(typeConfiguration, sessionFactory.getJdbcServices().getDialect(), (BasicType)keyMapping, null, typeConfiguration.getCurrentBaseSqlTypeIndicators());
    }

    static int countIds(Object[] ids) {
        int count = 0;
        for (int i = 1; i < ids.length; ++i) {
            if (ids[i] == null) continue;
            ++count;
        }
        return count;
    }

    static boolean hasSingleId(Object[] ids) {
        for (int i = 1; i < ids.length; ++i) {
            if (ids[i] == null) continue;
            return false;
        }
        return true;
    }

    static Object[] trimIdBatch(int length, Object[] keysToInitialize) {
        int newLength;
        for (newLength = length; newLength > 1 && keysToInitialize[newLength - 1] == null; --newLength) {
        }
        return newLength < length ? Arrays.copyOf(keysToInitialize, newLength) : keysToInitialize;
    }
}

