/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.select;

import java.util.Objects;
import org.hibernate.query.NullPrecedence;
import org.hibernate.query.SortDirection;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaOrder;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.expression.SqmExpression;

public class SqmSortSpecification
implements JpaOrder {
    private final SqmExpression sortExpression;
    private final SortDirection sortOrder;
    private final boolean ignoreCase;
    private NullPrecedence nullPrecedence;

    public SqmSortSpecification(SqmExpression sortExpression, SortDirection sortOrder, NullPrecedence nullPrecedence) {
        this(sortExpression, sortOrder, nullPrecedence, false);
    }

    public SqmSortSpecification(SqmExpression sortExpression, SortDirection sortOrder, NullPrecedence nullPrecedence, boolean ignoreCase) {
        assert (sortExpression != null);
        assert (sortOrder != null);
        assert (nullPrecedence != null);
        this.sortExpression = sortExpression;
        this.sortOrder = sortOrder;
        this.nullPrecedence = nullPrecedence;
        this.ignoreCase = ignoreCase;
    }

    public SqmSortSpecification(SqmExpression sortExpression) {
        this(sortExpression, SortDirection.ASCENDING, NullPrecedence.NONE);
    }

    public SqmSortSpecification(SqmExpression sortExpression, SortDirection sortOrder) {
        this(sortExpression, sortOrder, NullPrecedence.NONE);
    }

    public SqmSortSpecification copy(SqmCopyContext context) {
        return new SqmSortSpecification((SqmExpression)this.sortExpression.copy(context), this.sortOrder, this.nullPrecedence, this.ignoreCase);
    }

    public SqmExpression<?> getSortExpression() {
        return this.sortExpression;
    }

    @Override
    public SortDirection getSortDirection() {
        return this.sortOrder;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    public JpaOrder nullPrecedence(NullPrecedence nullPrecedence) {
        this.nullPrecedence = nullPrecedence;
        return this;
    }

    @Override
    public NullPrecedence getNullPrecedence() {
        return this.nullPrecedence;
    }

    @Override
    public JpaOrder reverse() {
        SortDirection newSortOrder = this.sortOrder == null ? SortDirection.DESCENDING : this.sortOrder.reverse();
        return new SqmSortSpecification(this.sortExpression, newSortOrder, this.nullPrecedence, this.ignoreCase);
    }

    @Override
    public JpaExpression<?> getExpression() {
        return this.getSortExpression();
    }

    public boolean isAscending() {
        return this.sortOrder == SortDirection.ASCENDING;
    }

    public void appendHqlString(StringBuilder sb) {
        this.sortExpression.appendHqlString(sb);
        if (this.sortOrder == SortDirection.DESCENDING) {
            sb.append(" desc");
            if (this.nullPrecedence != null) {
                if (this.nullPrecedence == NullPrecedence.FIRST) {
                    sb.append(" nulls first");
                } else {
                    sb.append(" nulls last");
                }
            }
        } else if (this.nullPrecedence != null) {
            sb.append(" asc");
            if (this.nullPrecedence == NullPrecedence.FIRST) {
                sb.append(" nulls first");
            } else {
                sb.append(" nulls last");
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SqmSortSpecification)) {
            return false;
        }
        SqmSortSpecification that = (SqmSortSpecification)o;
        return Objects.equals(this.sortExpression, that.sortExpression) && this.sortOrder == that.sortOrder && this.nullPrecedence == that.nullPrecedence;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sortExpression, this.sortOrder, this.nullPrecedence});
    }
}

