/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.xml;

import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.xml.XMLComponentReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.common.Assert;

public interface XMLElementReader<C>
extends org.jboss.staxmapper.XMLElementReader<C>,
XMLComponentReader<C> {
    @Override
    default public void whenAbsent(C context) {
    }

    default public <T> XMLElementReader<T> map(final Function<T, C> mapper) {
        return new XMLElementReader<T>(){

            public void readElement(XMLExtendedStreamReader reader, T context) throws XMLStreamException {
                XMLElementReader.this.readElement(reader, mapper.apply(context));
            }

            @Override
            public void whenAbsent(T context) {
                XMLElementReader.this.whenAbsent(mapper.apply(context));
            }
        };
    }

    default public <T> XMLElementReader<T> withContext(final Supplier<C> contextFactory, final BiConsumer<T, C> applicator) {
        return new XMLElementReader<T>(){

            public void readElement(XMLExtendedStreamReader reader, T parentContext) throws XMLStreamException {
                Object context = contextFactory.get();
                XMLElementReader.this.readElement(reader, context);
                applicator.accept(parentContext, context);
            }

            @Override
            public void whenAbsent(T parentContext) {
                Object context = contextFactory.get();
                XMLElementReader.this.whenAbsent(context);
                applicator.accept(parentContext, context);
            }
        };
    }

    public static <C> XMLElementReader<C> validate(final QName expected, final XMLElementReader<C> elementReader) {
        return new XMLElementReader<C>(){

            public void readElement(XMLExtendedStreamReader reader, C value) throws XMLStreamException {
                Assert.assertTrue((boolean)reader.isStartElement());
                if (!reader.getName().equals(expected)) {
                    throw ParseUtils.unexpectedElement(reader, Set.of(expected));
                }
                elementReader.readElement(reader, value);
                if (!reader.isEndElement()) {
                    throw ParseUtils.unexpectedElement(reader);
                }
                if (!reader.getName().equals(expected)) {
                    throw ParseUtils.unexpectedEndElement(reader);
                }
            }

            @Override
            public void whenAbsent(C context) {
                elementReader.whenAbsent(context);
            }
        };
    }
}

