/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.artifact.impl;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.TimerSupport;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.artifact.ExpiringSAMLArtifactMapEntry;
import org.opensaml.saml.common.binding.artifact.SAMLArtifactMap;
import org.opensaml.saml.common.binding.artifact.impl.ExpiringSAMLArtifactMapEntryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicSAMLArtifactMap
extends AbstractInitializableComponent
implements SAMLArtifactMap {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BasicSAMLArtifactMap.class);
    @NonnullAfterInit
    private Map<String, ExpiringSAMLArtifactMapEntry> artifactStore;
    @Nonnull
    private Duration artifactLifetime = Duration.ofMinutes(1L);
    @Nonnull
    private SAMLArtifactMap.SAMLArtifactMapEntryFactory entryFactory;
    @Nonnull
    private Duration cleanupInterval = Duration.ofMinutes(5L);
    @NonnullAfterInit
    private Timer cleanupTaskTimer;
    @Nullable
    private TimerTask cleanupTask;

    public BasicSAMLArtifactMap() {
        this.entryFactory = new ExpiringSAMLArtifactMapEntryFactory();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        this.artifactStore = new ConcurrentHashMap<String, ExpiringSAMLArtifactMapEntry>();
        if (!this.cleanupInterval.isZero()) {
            this.cleanupTask = new Cleanup();
            this.cleanupTaskTimer = new Timer(TimerSupport.getTimerName((Object)((Object)this)), true);
            this.cleanupTaskTimer.schedule(this.cleanupTask, this.cleanupInterval.toMillis(), this.cleanupInterval.toMillis());
        }
    }

    protected void doDestroy() {
        if (this.cleanupTask != null) {
            this.cleanupTask.cancel();
            this.cleanupTask = null;
            this.cleanupTaskTimer = null;
        }
        this.artifactStore = null;
        super.doDestroy();
    }

    @Nonnull
    public Duration getArtifactLifetime() {
        return this.artifactLifetime;
    }

    @Nonnull
    public SAMLArtifactMap.SAMLArtifactMapEntryFactory getEntryFactory() {
        return this.entryFactory;
    }

    public void setArtifactLifetime(@Nonnull Duration lifetime) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull((Object)lifetime, (String)"Lifetime cannot be null");
        Constraint.isFalse((lifetime.isNegative() || lifetime.isZero() ? 1 : 0) != 0, (String)"Lifetime must be positive");
        this.artifactLifetime = lifetime;
    }

    public void setCleanupInterval(@Nonnull Duration interval) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull((Object)interval, (String)"Interval cannot be null");
        Constraint.isFalse((boolean)interval.isNegative(), (String)"Interval cannot be negative");
        this.cleanupInterval = interval;
    }

    public void setEntryFactory(@Nonnull SAMLArtifactMap.SAMLArtifactMapEntryFactory factory) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.entryFactory = (SAMLArtifactMap.SAMLArtifactMapEntryFactory)Constraint.isNotNull((Object)factory, (String)"SAMLArtifactMapEntryFactory cannot be null");
    }

    public boolean contains(@Nonnull @NotEmpty String artifact) throws IOException {
        return this.artifactStore.containsKey(artifact);
    }

    @Nullable
    public SAMLArtifactMap.SAMLArtifactMapEntry get(@Nonnull @NotEmpty String artifact) throws IOException {
        this.log.debug("Attempting to retrieve entry for artifact: {}", (Object)artifact);
        ExpiringSAMLArtifactMapEntry entry = this.artifactStore.get(artifact);
        if (entry == null) {
            this.log.debug("No entry found for artifact: {}", (Object)artifact);
            return null;
        }
        if (!entry.isValid()) {
            this.log.debug("Entry for artifact was expired: {}", (Object)artifact);
            this.remove(artifact);
            return null;
        }
        this.log.debug("Found valid entry for artifact: {}", (Object)artifact);
        return entry;
    }

    public void put(@Nonnull @NotEmpty String artifact, @Nonnull @NotEmpty String relyingPartyId, @Nonnull @NotEmpty String issuerId, @Nonnull SAMLObject samlMessage) throws IOException {
        ExpiringSAMLArtifactMapEntry artifactEntry = (ExpiringSAMLArtifactMapEntry)this.entryFactory.newEntry(artifact, issuerId, relyingPartyId, samlMessage);
        artifactEntry.setExpiration(Instant.now().plus(this.getArtifactLifetime()));
        if (this.log.isDebugEnabled()) {
            this.log.debug("Storing new artifact entry '{}' for relying party '{}', expiring at '{}'", new Object[]{artifact, relyingPartyId, artifactEntry.getExpiration()});
        }
        this.artifactStore.put(artifact, artifactEntry);
    }

    public void remove(@Nonnull @NotEmpty String artifact) throws IOException {
        this.log.debug("Removing artifact entry: {}", (Object)artifact);
        this.artifactStore.remove(artifact);
    }

    protected class Cleanup
    extends TimerTask {
        protected Cleanup() {
        }

        @Override
        public void run() {
            BasicSAMLArtifactMap.this.log.info("Running cleanup task");
            Instant now = Instant.now();
            Iterator<Map.Entry<String, ExpiringSAMLArtifactMapEntry>> i = BasicSAMLArtifactMap.this.artifactStore.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<String, ExpiringSAMLArtifactMapEntry> entry = i.next();
                if (entry.getValue().isValid(now)) continue;
                i.remove();
            }
        }
    }
}

