/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.persistenceprovider;

import jakarta.persistence.spi.PersistenceProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.jboss.as.controller.ModuleIdentifierUtil;
import org.jboss.as.jpa.config.Configuration;
import org.jboss.as.jpa.persistenceprovider.PersistenceProviderResolverImpl;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;

public class PersistenceProviderLoader {
    public static void loadDefaultProvider() throws ModuleLoadException {
        String defaultProviderModule = Configuration.getDefaultProviderModuleName();
        PersistenceProviderLoader.loadProviderModuleByName(defaultProviderModule);
    }

    public static List<PersistenceProvider> loadProviderModuleByName(String moduleName) throws ModuleLoadException {
        moduleName = ModuleIdentifierUtil.parseCanonicalModuleIdentifier((String)moduleName);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        Module module = moduleLoader.loadModule(moduleName);
        ServiceLoader serviceLoader = module.loadService(PersistenceProvider.class);
        ArrayList<PersistenceProvider> result = new ArrayList<PersistenceProvider>();
        if (serviceLoader != null) {
            for (PersistenceProvider provider1 : serviceLoader) {
                PersistenceProviderResolverImpl.getInstance().addPersistenceProvider(provider1);
                result.add(provider1);
            }
        }
        return result;
    }

    public static PersistenceProvider loadProviderFromDeployment(ClassLoader classLoader, String persistenceProviderClassName) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return (PersistenceProvider)classLoader.loadClass(persistenceProviderClassName).newInstance();
    }
}

