/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.jmx.logging.JmxLogger;
import org.jboss.as.jmx.model.ModelControllerMBeanHelper;

class ObjectNameAddressUtil {
    private static final EscapedCharacter[] ESCAPED_KEY_CHARACTERS;
    private static final EscapedCharacter[] ESCAPED_QUOTED_VALUE_CHARACTERS;

    ObjectNameAddressUtil() {
    }

    static ObjectName createObjectName(String domain, PathAddress pathAddress) {
        return ObjectNameAddressUtil.createObjectName(domain, pathAddress, null);
    }

    static ObjectName createObjectName(String domain, PathAddress pathAddress, ObjectNameCreationContext context) {
        if (pathAddress.size() == 0) {
            return ModelControllerMBeanHelper.createRootObjectName(domain);
        }
        StringBuilder sb = new StringBuilder(domain);
        sb.append(":");
        boolean first = true;
        for (PathElement element : pathAddress) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            ObjectNameAddressUtil.escapeKey(ESCAPED_KEY_CHARACTERS, sb, element.getKey(), context);
            sb.append("=");
            ObjectNameAddressUtil.escapeValue(sb, element.getValue(), context);
        }
        try {
            return ObjectName.getInstance(sb.toString());
        }
        catch (MalformedObjectNameException e) {
            throw JmxLogger.ROOT_LOGGER.cannotCreateObjectName(e, pathAddress, sb.toString());
        }
    }

    static PathAddress resolvePathAddress(String domain, Resource rootResource, ObjectName name) {
        return ObjectNameAddressUtil.resolvePathAddress(ModelControllerMBeanHelper.createRootObjectName(domain), rootResource, name);
    }

    static PathAddress resolvePathAddress(ObjectName domainRoot, Resource rootResource, ObjectName name) {
        String domain = domainRoot.getDomain();
        if (!name.getDomain().equals(domain)) {
            return null;
        }
        if (name.equals(domainRoot)) {
            return PathAddress.EMPTY_ADDRESS;
        }
        Hashtable<String, String> properties = name.getKeyPropertyList();
        return ObjectNameAddressUtil.searchPathAddress(PathAddress.EMPTY_ADDRESS, rootResource, properties);
    }

    private static PathAddress searchPathAddress(PathAddress address, Resource resource, Map<String, String> properties) {
        if (properties.size() == 0) {
            return address;
        }
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            PathElement childElement = PathElement.pathElement((String)ObjectNameAddressUtil.replaceEscapedCharactersInKey(entry.getKey()), (String)ObjectNameAddressUtil.replaceEscapedCharactersInValue(entry.getValue()));
            Resource child = resource.getChild(childElement);
            if (child == null) continue;
            HashMap<String, String> childProps = new HashMap<String, String>(properties);
            childProps.remove(entry.getKey());
            PathAddress foundAddr = ObjectNameAddressUtil.searchPathAddress(address.append(new PathElement[]{childElement}), child, childProps);
            if (foundAddr == null) continue;
            return foundAddr;
        }
        return null;
    }

    static PathAddress toPathAddress(String domain, ImmutableManagementResourceRegistration registry, ObjectName name) {
        if (!name.getDomain().equals(domain)) {
            return PathAddress.EMPTY_ADDRESS;
        }
        if (name.equals(ModelControllerMBeanHelper.createRootObjectName(domain))) {
            return PathAddress.EMPTY_ADDRESS;
        }
        Hashtable<String, String> properties = name.getKeyPropertyList();
        return ObjectNameAddressUtil.searchPathAddress(PathAddress.EMPTY_ADDRESS, registry, properties);
    }

    static PathAddress toPathAddress(ObjectName domainRoot, ImmutableManagementResourceRegistration registry, ObjectName name) {
        String domain = domainRoot.getDomain();
        if (!name.getDomain().equals(domain)) {
            return PathAddress.EMPTY_ADDRESS;
        }
        if (name.equals(domainRoot)) {
            return PathAddress.EMPTY_ADDRESS;
        }
        Hashtable<String, String> properties = name.getKeyPropertyList();
        return ObjectNameAddressUtil.searchPathAddress(PathAddress.EMPTY_ADDRESS, registry, properties);
    }

    private static PathAddress searchPathAddress(PathAddress address, ImmutableManagementResourceRegistration registry, Map<String, String> properties) {
        if (properties.size() == 0) {
            return address;
        }
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            PathAddress childAddress = PathAddress.pathAddress((String)ObjectNameAddressUtil.replaceEscapedCharactersInKey(entry.getKey()), (String)ObjectNameAddressUtil.replaceEscapedCharactersInValue(entry.getValue()));
            ImmutableManagementResourceRegistration subModel = registry.getSubModel(childAddress);
            if (subModel == null) continue;
            HashMap<String, String> childProps = new HashMap<String, String>(properties);
            childProps.remove(entry.getKey());
            PathAddress foundAddr = ObjectNameAddressUtil.searchPathAddress(address.append(childAddress), subModel, childProps);
            if (foundAddr == null) continue;
            return foundAddr;
        }
        return null;
    }

    private static void escapeKey(EscapedCharacter[] escapedCharacters, StringBuilder sb, String value, ObjectNameCreationContext context) {
        String escaped;
        String string = escaped = context == null ? null : context.getCachedKey(value);
        if (escaped == null) {
            escaped = value;
            for (EscapedCharacter escapedCharacter : escapedCharacters) {
                escaped = escapedCharacter.escapeString(escaped);
            }
            if (context != null) {
                context.cacheKey(value, escaped);
            }
        }
        sb.append(escaped);
    }

    private static void escapeValue(StringBuilder sb, String value, ObjectNameCreationContext context) {
        Object escaped;
        Object object = escaped = context == null ? null : context.getCachedValue(value);
        if (escaped == null) {
            boolean quoted;
            escaped = value;
            for (EscapedCharacter escapedCharacter : ESCAPED_QUOTED_VALUE_CHARACTERS) {
                escaped = escapedCharacter.escapeString((String)escaped);
            }
            boolean bl = quoted = !value.equals(escaped);
            if (!quoted) {
                for (char c : value.toCharArray()) {
                    if (c != ':' && c != ',' && c != '=') continue;
                    quoted = true;
                    break;
                }
            }
            if (quoted) {
                escaped = "\"" + (String)escaped + "\"";
            }
            if (context != null) {
                context.cacheValue(value, (String)escaped);
            }
        }
        sb.append((String)escaped);
    }

    private static String replaceEscapedCharactersInKey(String escaped) {
        for (EscapedCharacter escapedCharacter : ESCAPED_KEY_CHARACTERS) {
            escaped = escapedCharacter.unescapeString(escaped);
        }
        return escaped;
    }

    private static String replaceEscapedCharactersInValue(String escaped) {
        if (escaped.startsWith("\"") && escaped.endsWith("\"")) {
            String replaced = escaped.substring(1, escaped.length() - 1);
            for (int i = ESCAPED_QUOTED_VALUE_CHARACTERS.length - 1; i >= 0; --i) {
                replaced = ESCAPED_QUOTED_VALUE_CHARACTERS[i].unescapeString(replaced);
            }
            return replaced;
        }
        return escaped;
    }

    static {
        ArrayList<EscapedCharacter> keys = new ArrayList<EscapedCharacter>();
        keys.add(new EscapedCharacter(Character.valueOf('*')));
        keys.add(new EscapedCharacter(Character.valueOf('?')));
        keys.add(new EscapedCharacter(Character.valueOf(':')));
        keys.add(new EscapedCharacter(Character.valueOf('=')));
        keys.add(new EscapedCharacter(Character.valueOf(',')));
        ESCAPED_KEY_CHARACTERS = keys.toArray(new EscapedCharacter[keys.size()]);
        ArrayList<EscapedCharacter> values = new ArrayList<EscapedCharacter>();
        values.add(new EscapedCharacter("\\", "\\\\"));
        values.add(new EscapedCharacter("*", "\\*"));
        values.add(new EscapedCharacter("\n", "\\n"));
        values.add(new EscapedCharacter("?", "\\?"));
        values.add(new EscapedCharacter("\"", "\\\""));
        ESCAPED_QUOTED_VALUE_CHARACTERS = values.toArray(new EscapedCharacter[values.size()]);
    }

    static final class ObjectNameCreationContext {
        private final Map<String, String> keyCache = new HashMap<String, String>();
        private final Map<String, String> valueCache = new HashMap<String, String>();

        ObjectNameCreationContext() {
        }

        static ObjectNameCreationContext create() {
            return new ObjectNameCreationContext();
        }

        private String getCachedKey(String key) {
            return this.keyCache.get(key);
        }

        private void cacheKey(String key, String toCache) {
            this.keyCache.put(key, toCache);
        }

        private String getCachedValue(String value) {
            return this.valueCache.get(value);
        }

        private void cacheValue(String value, String toCache) {
            this.valueCache.put(value, toCache);
        }
    }

    private static class EscapedCharacter {
        private final Pattern pattern;
        private final String quotedReplacement;
        private final Pattern reversePattern;
        private final String reverseQuotedReplacement;

        EscapedCharacter(Character ch) {
            this(String.valueOf(ch), "%x" + Integer.toHexString(ch.charValue()));
        }

        EscapedCharacter(String toReplace, String replacement) {
            this.pattern = Pattern.compile(toReplace, 16);
            this.quotedReplacement = Matcher.quoteReplacement(replacement);
            this.reversePattern = Pattern.compile(replacement, 16);
            this.reverseQuotedReplacement = Matcher.quoteReplacement(toReplace);
        }

        String escapeString(String toEscape) {
            return this.pattern.matcher(toEscape).replaceAll(this.quotedReplacement);
        }

        String unescapeString(String toUnescape) {
            return this.reversePattern.matcher(toUnescape).replaceAll(this.reverseQuotedReplacement);
        }
    }
}

