/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.service;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.as.controller.RequirementServiceTarget;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.infinispan.service.InfinispanServiceDescriptor;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class CacheConfigurationServiceInstaller
implements ServiceInstaller {
    private static final Function<Configuration, ConfigurationBuilder> CLONE = new Function<Configuration, ConfigurationBuilder>(){

        @Override
        public ConfigurationBuilder apply(Configuration configuration) {
            return new ConfigurationBuilder().read(configuration);
        }
    };
    private final BinaryServiceConfiguration configuration;
    private final ServiceDependency<ConfigurationBuilder> builder;

    public static ServiceDependency<ConfigurationBuilder> fromTemplate(BinaryServiceConfiguration configuration) {
        return configuration.getServiceDependency(InfinispanServiceDescriptor.CACHE_CONFIGURATION).map(CLONE);
    }

    public CacheConfigurationServiceInstaller(BinaryServiceConfiguration configuration, ServiceDependency<ConfigurationBuilder> builder) {
        this.configuration = configuration;
        this.builder = builder;
    }

    public ServiceController<?> install(RequirementServiceTarget target) {
        final ServiceDependency manager = this.configuration.getServiceDependency(InfinispanServiceDescriptor.CACHE_CONTAINER);
        final String cacheName = this.configuration.getChildName();
        Consumer<Configuration> start = new Consumer<Configuration>(){

            @Override
            public void accept(Configuration configuration) {
                ((EmbeddedCacheManager)manager.get()).defineConfiguration(cacheName, configuration);
            }
        };
        Consumer<Configuration> stop = new Consumer<Configuration>(){

            @Override
            public void accept(Configuration configuration) {
                ((EmbeddedCacheManager)manager.get()).undefineConfiguration(cacheName);
            }
        };
        ServiceDependency factory = this.builder.map((Function)new Function<ConfigurationBuilder, Configuration>(){

            @Override
            public Configuration apply(ConfigurationBuilder builder) {
                builder.simpleCache(builder.clustering().cacheMode() == CacheMode.LOCAL && builder.memory().storage() == StorageType.HEAP && !builder.transaction().transactionMode().isTransactional() && builder.persistence().stores().isEmpty() && !builder.statistics().create().enabled());
                builder.encoding().mediaType(builder.memory().storage().canStoreReferences() ? MediaType.APPLICATION_OBJECT : ((EmbeddedCacheManager)manager.get()).getCacheManagerConfiguration().serialization().marshaller().mediaType());
                return builder.build();
            }
        });
        return ((ServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((Supplier)factory).provides(this.configuration.resolveServiceName(InfinispanServiceDescriptor.CACHE_CONFIGURATION))).requires(List.of(this.builder, manager))).onStart((Consumer)start)).onStop((Consumer)stop)).build()).install((ServiceTarget)target);
    }
}

