/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.remote;

import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.wildfly.clustering.cache.CacheConfiguration;
import org.wildfly.clustering.cache.Key;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.function.Supplier;
import org.wildfly.clustering.server.Registrar;
import org.wildfly.clustering.server.Registration;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.SessionManager;
import org.wildfly.clustering.session.SessionManagerConfiguration;
import org.wildfly.clustering.session.cache.AbstractSessionManager;
import org.wildfly.clustering.session.cache.SessionFactory;
import org.wildfly.clustering.session.infinispan.remote.HotRodSessionManagerConfiguration;
import org.wildfly.clustering.session.infinispan.remote.metadata.SessionCreationMetaDataKey;

public class HotRodSessionManager<C, MV, AV, SC>
extends AbstractSessionManager<C, MV, AV, SC> {
    private final Registrar<java.util.function.Consumer<ImmutableSession>> expirationListenerRegistrar;
    private final java.util.function.Consumer<ImmutableSession> expirationListener;
    private final RemoteCache<Key<String>, ?> cache;
    private AtomicReference<Registration> expirationListenerRegistration = new AtomicReference();

    public HotRodSessionManager(Supplier<SessionManager<SC>> manager, SessionManagerConfiguration<C> configuration, SessionFactory<C, MV, AV, SC> factory, HotRodSessionManagerConfiguration hotrod) {
        super(manager, configuration, (CacheConfiguration)hotrod, factory, (java.util.function.Consumer)Consumer.empty());
        this.expirationListenerRegistrar = hotrod.getExpirationListenerRegistrar();
        this.expirationListener = configuration.getExpirationListener();
        this.cache = hotrod.getCache();
    }

    public boolean isStarted() {
        return this.expirationListenerRegistration.get() != null;
    }

    public void start() {
        this.expirationListenerRegistration.set(this.expirationListenerRegistrar.register(this.expirationListener));
    }

    public void stop() {
        Optional.ofNullable(this.expirationListenerRegistration.getAndSet(null)).ifPresent(Registration::close);
    }

    public Set<String> getActiveSessions() {
        return this.getSessions();
    }

    public Set<String> getSessions() {
        try (Stream keys = this.cache.withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).keySet().stream();){
            Set<String> set = keys.filter(SessionCreationMetaDataKey.class::isInstance).map(Key::getId).collect(Collectors.toUnmodifiableSet());
            return set;
        }
    }
}

