/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.property;

import java.util.Stack;
import java.util.regex.Pattern;
import org.jboss.metadata.property.CompositePropertyResolver;
import org.jboss.metadata.property.JBossASSimpleExpressionResolver;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.metadata.property.SimpleExpressionResolver;

public class DefaultExpressionReplacer
implements PropertyReplacer {
    private Pattern EXPRESSION_PATTERN = Pattern.compile(".*\\$\\{.*\\}.*");
    private static final int INITIAL = 0;
    private static final int GOT_DOLLAR = 1;
    private static final int GOT_OPEN_BRACE = 2;
    private final SimpleExpressionResolver resolver;

    DefaultExpressionReplacer(SimpleExpressionResolver resolver) {
        this.resolver = DefaultExpressionReplacer.getDefaultCompatibleResolver(resolver);
    }

    private static SimpleExpressionResolver getDefaultCompatibleResolver(SimpleExpressionResolver resolver) {
        if (resolver instanceof JBossASSimpleExpressionResolver || resolver instanceof CompositePropertyResolver && ((CompositePropertyResolver)resolver).hasJBossASExpressionSupport) {
            return resolver;
        }
        return new CompositePropertyResolver(resolver, new JBossASSimpleExpressionResolver(){

            @Override
            protected String resolveKey(String key) {
                return null;
            }
        });
    }

    @Override
    public String replaceProperties(String text) {
        return this.resolveExpressionStringRecursively(text, false, true);
    }

    private String resolveExpressionStringRecursively(String expressionString, boolean ignoreResolutionFailure, boolean initial) {
        ParseAndResolveResult resolved = this.parseAndResolve(expressionString, ignoreResolutionFailure);
        if (resolved.recursive) {
            return this.resolveExpressionStringRecursively(resolved.result, true, false);
        }
        if (resolved.modified) {
            return resolved.result;
        }
        if (initial && this.EXPRESSION_PATTERN.matcher(expressionString).matches()) {
            assert (ignoreResolutionFailure);
            return expressionString;
        }
        return expressionString;
    }

    private ParseAndResolveResult parseAndResolve(String initialValue, boolean lenient) {
        StringBuilder builder = new StringBuilder();
        int len = initialValue.length();
        int state = 0;
        int ignoreBraceLevel = 0;
        boolean modified = false;
        Stack<OpenExpression> stack = new Stack<OpenExpression>();
        int i = 0;
        while (i < len) {
            int ch = initialValue.codePointAt(i);
            block0 : switch (state) {
                case 0: {
                    switch (ch) {
                        case 36: {
                            stack = DefaultExpressionReplacer.addToStack(stack, i);
                            state = 1;
                            break block0;
                        }
                    }
                    builder.appendCodePoint(ch);
                    break;
                }
                case 1: {
                    switch (ch) {
                        case 123: {
                            state = 2;
                            break block0;
                        }
                    }
                    if (stack.size() == 1) {
                        stack.clear();
                        if (ch != 36) {
                            builder.append('$');
                        } else {
                            modified = true;
                        }
                        builder.appendCodePoint(ch);
                        state = 0;
                        break;
                    }
                    stack.pop();
                    state = 2;
                    break;
                }
                case 2: {
                    switch (ch) {
                        case 36: {
                            stack.push(new OpenExpression(i));
                            state = 1;
                            break block0;
                        }
                        case 123: {
                            ++ignoreBraceLevel;
                            break block0;
                        }
                        case 125: {
                            String resolved;
                            if (ignoreBraceLevel > 0) {
                                --ignoreBraceLevel;
                                break block0;
                            }
                            String toResolve = DefaultExpressionReplacer.getStringToResolve(initialValue, stack, i);
                            SimpleExpressionResolver.ResolutionResult rr = this.resolver.resolveExpressionContent(toResolve);
                            String string = resolved = rr == null ? null : rr.getValue();
                            if (resolved != null) {
                                if (this.EXPRESSION_PATTERN.matcher(resolved).matches()) {
                                    return DefaultExpressionReplacer.createRecursiveResult(initialValue, resolved, stack, i);
                                }
                                DefaultExpressionReplacer.recordResolutionInStack(resolved, stack);
                                if (stack.size() == 0) {
                                    builder.append(resolved);
                                    state = 0;
                                } else {
                                    state = 2;
                                }
                                modified = true;
                                break block0;
                            }
                            if (stack.size() > 1) {
                                DefaultExpressionReplacer.recordResolutionInStack(toResolve, stack);
                                state = 2;
                                break block0;
                            }
                            if (lenient) {
                                return new ParseAndResolveResult(initialValue, false, false);
                            }
                            throw new IllegalStateException("Failed to resolve expression: " + toResolve);
                        }
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            i = initialValue.offsetByCodePoints(i, 1);
        }
        if (stack != null && stack.size() > 0) {
            if (state == 1) {
                stack.pop();
            }
            if (stack.size() > 0) {
                throw new IllegalStateException("Incomplete expression: " + initialValue);
            }
            builder.append('$');
        }
        return new ParseAndResolveResult(builder.toString(), modified, false);
    }

    private static Stack<OpenExpression> addToStack(Stack<OpenExpression> stack, int startIndex) {
        Stack<OpenExpression> result = stack == null ? new Stack<OpenExpression>() : stack;
        result.push(new OpenExpression(startIndex));
        return result;
    }

    private static String getStringToResolve(String initialValue, Stack<OpenExpression> stack, int expressionEndIndex) {
        int stackSize = stack.size();
        int expressionElement = -1;
        OpenExpression firstUnresolved = null;
        for (int i = stackSize - 1; i >= 0; --i) {
            OpenExpression oe = (OpenExpression)stack.get(i);
            if (oe.resolvedValue != null) continue;
            expressionElement = i;
            firstUnresolved = oe;
            break;
        }
        assert (expressionElement > -1);
        firstUnresolved.endIndex = expressionEndIndex;
        if (expressionElement == stackSize - 1) {
            return initialValue.substring(firstUnresolved.startIndex + 2, expressionEndIndex);
        }
        StringBuilder sb = new StringBuilder();
        int nextStart = firstUnresolved.startIndex + 2;
        for (int i = expressionElement + 1; i < stackSize; ++i) {
            OpenExpression oe = (OpenExpression)stack.get(i);
            sb.append(initialValue.substring(nextStart, oe.startIndex));
            sb.append(oe.resolvedValue);
            nextStart = oe.endIndex + 1;
        }
        if (nextStart < expressionEndIndex) {
            sb.append(initialValue.substring(nextStart, expressionEndIndex));
        }
        return sb.toString();
    }

    private static ParseAndResolveResult createRecursiveResult(String initialValue, String val, Stack<OpenExpression> stack, int expressionEndIndex) {
        Object result;
        int initialLength = initialValue.length();
        int expressionIndex = -1;
        while (expressionIndex == -1) {
            OpenExpression oe = stack.pop();
            if (oe.resolvedValue != null) continue;
            expressionIndex = oe.startIndex;
        }
        if (expressionIndex == 0 && expressionEndIndex == initialLength - 1) {
            result = val;
        } else if (expressionIndex == 0) {
            result = val + initialValue.substring(expressionEndIndex + 1);
        } else {
            StringBuilder sb = new StringBuilder(initialValue.substring(0, expressionIndex));
            sb.append(val);
            if (expressionEndIndex < initialLength - 1) {
                sb.append(initialValue.substring(expressionEndIndex + 1));
            }
            result = sb.toString();
        }
        return new ParseAndResolveResult((String)result, true, true);
    }

    private static void recordResolutionInStack(String val, Stack<OpenExpression> stack) {
        for (int i = stack.size() - 1; i >= 0; --i) {
            OpenExpression oe;
            OpenExpression openExpression = oe = i == 0 ? stack.pop() : stack.peek();
            if (oe.resolvedValue == null) {
                oe.resolvedValue = val;
                break;
            }
            assert (i > 0);
            stack.pop();
        }
    }

    private static class ParseAndResolveResult {
        private final String result;
        private final boolean modified;
        private final boolean recursive;

        private ParseAndResolveResult(String result, boolean modified, boolean recursive) {
            this.result = result;
            this.modified = modified;
            this.recursive = recursive;
        }
    }

    private static class OpenExpression {
        private final int startIndex;
        private int endIndex = -1;
        private String resolvedValue;

        private OpenExpression(int startIndex) {
            this.startIndex = startIndex;
        }
    }
}

