/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.core.impl;

import java.util.BitSet;
import java.util.Map;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.api.query.ClosableIteratorWithCount;
import org.infinispan.commons.api.query.EntityEntry;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.objectfilter.impl.syntax.parser.IckleParsingResult;
import org.infinispan.query.core.impl.HybridQuery;
import org.infinispan.query.core.impl.MappingEntryIterator;
import org.infinispan.query.core.stats.impl.LocalQueryStatistics;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;

public class MetadataHybridQuery<T, S>
extends HybridQuery<T, S> {
    private final BitSet scoreProjections = new BitSet();
    private final boolean versionProjection;

    public MetadataHybridQuery(QueryFactory queryFactory, AdvancedCache<?, ?> cache, String queryString, IckleParsingResult.StatementType statementType, Map<String, Object> namedParameters, ObjectFilter objectFilter, long startOffset, int maxResults, Query<?> baseQuery, LocalQueryStatistics queryStatistics, boolean local, boolean allSortFieldsAreStored) {
        super(queryFactory, cache, queryString, statementType, namedParameters, objectFilter, startOffset, maxResults, baseQuery, queryStatistics, local, allSortFieldsAreStored);
        String[] projection = objectFilter.getProjection();
        if (projection == null) {
            this.versionProjection = false;
            return;
        }
        boolean needVersion = false;
        for (int i = 0; i < projection.length; ++i) {
            if ("__ISPN_Score".equals(projection[i])) {
                this.scoreProjections.set(i);
            }
            if (!"__ISPN_Version".equals(projection[i])) continue;
            needVersion = true;
        }
        this.versionProjection = needVersion;
    }

    @Override
    protected ClosableIteratorWithCount<ObjectFilter.FilterResult> getInternalIterator() {
        ClosableIteratorWithCount iterator = this.baseQuery.startOffset(0L).maxResults(this.hybridMaxResult()).local(this.local).scoreRequired(this.scoreProjections.cardinality() > 0).entryIterator(this.versionProjection);
        return new MappingEntryIterator(iterator, this::filter, iterator.count());
    }

    private ObjectFilter.FilterResult filter(EntityEntry<Object, S> entry) {
        Object value = entry.value();
        if (value == null) {
            return null;
        }
        ObjectFilter.FilterResult filter = this.objectFilter.filter(entry.key(), value, entry.metadata());
        String[] projection = this.objectFilter.getProjection();
        if (projection == null) {
            return filter;
        }
        this.scoreProjections.stream().forEach(i -> {
            filter.getProjection()[i] = Float.valueOf(entry.score());
        });
        return filter;
    }
}

