/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.marshalling;

import java.io.IOException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.OneToManyTranscoder;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;
import org.wildfly.clustering.marshalling.MarshalledValue;
import org.wildfly.clustering.marshalling.MarshalledValueFactory;

public class MarshalledValueTranscoder<C>
extends OneToManyTranscoder {
    private final MarshalledValueFactory<C> factory;
    private final Marshaller marshaller;

    public MarshalledValueTranscoder(MediaType type, MarshalledValueFactory<C> factory, Marshaller marshaller) {
        super(type, new MediaType[]{MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_OCTET_STREAM});
        this.factory = factory;
        this.marshaller = marshaller;
    }

    protected Object doTranscode(Object content, MediaType contentType, MediaType destinationType) {
        if (contentType.match(destinationType)) {
            return content;
        }
        if (contentType.match(this.mainType)) {
            MarshalledValue value = this.factory.createMarshalledValue(content);
            if (destinationType.match(MediaType.APPLICATION_OBJECT)) {
                return value;
            }
            if (destinationType.match(MediaType.APPLICATION_OCTET_STREAM)) {
                try {
                    return this.marshaller.objectToByteBuffer((Object)value);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw Log.CONTAINER.errorTranscoding(Util.toStr((Object)content), contentType, destinationType, (Throwable)e);
                }
                catch (IOException e) {
                    throw Log.CONTAINER.errorTranscoding(Util.toStr((Object)content), contentType, destinationType, (Throwable)e);
                }
            }
        } else if (destinationType.match(this.mainType) && (contentType.match(MediaType.APPLICATION_OBJECT) || contentType.match(MediaType.APPLICATION_OCTET_STREAM))) {
            try {
                Object object = contentType.match(MediaType.APPLICATION_OCTET_STREAM) ? this.marshaller.objectFromByteBuffer((byte[])content) : content;
                MarshalledValue value = (MarshalledValue)object;
                return value.get(this.factory.getMarshallingContext());
            }
            catch (IOException | ClassNotFoundException e) {
                throw Log.CONTAINER.errorTranscoding(Util.toStr((Object)content), contentType, destinationType, (Throwable)e);
            }
        }
        throw Log.CONTAINER.unsupportedConversion(Util.toStr((Object)content), contentType, destinationType);
    }
}

