/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache;

import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;

public interface CacheEntryMutator
extends Runnable {
    public static final System.Logger LOGGER = System.getLogger(CacheEntryMutator.class.getName());
    public static final CacheEntryMutator EMPTY = new CacheEntryMutator(){
        private final CompletionStage<Void> completed = CompletableFuture.completedStage(null);

        @Override
        public CompletionStage<Void> runAsync() {
            return this.completed;
        }

        @Override
        public CacheEntryMutator withMaxIdle(Supplier<Duration> maxIdle) {
            return this;
        }
    };

    @Override
    default public void run() {
        try {
            this.runAsync().toCompletableFuture().join();
        }
        catch (CancellationException | CompletionException e) {
            LOGGER.log(System.Logger.Level.ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public CompletionStage<Void> runAsync();

    public CacheEntryMutator withMaxIdle(Supplier<Duration> var1);

    public static CacheEntryMutator of(final Iterable<CacheEntryMutator> mutators) {
        return new CacheEntryMutator(){

            @Override
            public CompletionStage<Void> runAsync() {
                CompletionStage<Object> result = CompletableFuture.completedStage(null);
                for (CacheEntryMutator mutator : mutators) {
                    result = result.runAfterBoth(mutator.runAsync(), (Runnable)org.wildfly.clustering.function.Runnable.empty());
                }
                return result;
            }

            @Override
            public CacheEntryMutator withMaxIdle(Supplier<Duration> maxIdle) {
                for (CacheEntryMutator mutator : mutators) {
                    mutator.withMaxIdle(maxIdle);
                }
                return this;
            }
        };
    }
}

