/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retry;

import io.github.resilience4j.retry.Retry;

public class MaxRetriesExceededException
extends RuntimeException {
    private final transient String causingRetryName;

    private MaxRetriesExceededException(String causingRetryName, String message, boolean writeableStackTrace) {
        super(message, null, false, writeableStackTrace);
        this.causingRetryName = causingRetryName;
    }

    public static MaxRetriesExceededException createMaxRetriesExceededException(Retry retry) {
        boolean writeStackTrace = retry.getRetryConfig().isWritableStackTraceEnabled();
        String message = String.format("Retry '%s' has exhausted all attempts (%d)", retry.getName(), retry.getRetryConfig().getMaxAttempts());
        return new MaxRetriesExceededException(retry.getName(), message, writeStackTrace);
    }

    public String getCausingRetryName() {
        return this.causingRetryName;
    }
}

