/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.authz.jacc;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.principal.NamedGroup;
import org.wildfly.security.authz.Roles;

class RoleToGroupMapper {
    RoleToGroupMapper() {
    }

    static Collection<Principal> convert(Principal caller, Roles roles) {
        ArrayList<Principal> principals = new ArrayList<Principal>();
        SimpleGroup rolesGroup = new SimpleGroup("Roles");
        for (String role : roles) {
            rolesGroup.addMember((Principal)new NamePrincipal(role));
        }
        principals.add((Principal)((Object)rolesGroup));
        SimpleGroup callerPrincipalGroup = new SimpleGroup("CallerPrincipal");
        callerPrincipalGroup.addMember(caller);
        principals.add((Principal)((Object)callerPrincipalGroup));
        return principals;
    }

    private static class SimpleGroup
    implements NamedGroup {
        private final String name;
        private final Set<Principal> principals;

        SimpleGroup(String name) {
            this.name = name;
            this.principals = new HashSet<Principal>();
        }

        public String getName() {
            return this.name;
        }

        boolean addMember(Principal principal) {
            return this.principals.add(principal);
        }

        public Enumeration<? extends Principal> members() {
            return Collections.enumeration(this.principals);
        }

        public boolean isMember(Principal principal) {
            return this.principals.contains(principal);
        }
    }
}

